/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.item.custom;

import com.cerbon.bosses_of_mass_destruction.api.maelstrom.static_utilities.MathUtils;
import com.cerbon.bosses_of_mass_destruction.api.maelstrom.static_utilities.VecUtils;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class WallTeleport {
    private final ServerLevel level;
    private final Entity entity;

    public WallTeleport(ServerLevel level, Entity entity) {
        this.level = level;
        this.entity = entity;
    }

    public boolean tryTeleport(Vec3 direction, Vec3 position) {
        return this.tryTeleport(direction, position, this::teleportTo);
    }

    public boolean tryTeleport(Vec3 direction, Vec3 position, Consumer<BlockPos> action) {
        BlockPos teleportEnd;
        Context context = new Context(direction, position);
        BlockPos teleportStart = this.getTeleportStart(context);
        if (teleportStart != null && (teleportEnd = this.getTeleportEnd(context, teleportStart)) != null) {
            action.accept(teleportEnd);
            return true;
        }
        return false;
    }

    private BlockPos getTeleportStart(Context context) {
        BlockPos startPos = new BlockPos(context.position);
        double startRange = 3.0;
        BlockPos endPos = new BlockPos(context.position.m_82549_(context.direction.m_82490_(startRange)));
        List<BlockPos> blocksToCheck = MathUtils.getBlocksInLine(startPos, endPos);
        for (BlockPos pos : blocksToCheck) {
            if (!this.level.m_8055_(pos).m_60796_((BlockGetter)this.level, pos)) continue;
            return pos;
        }
        return null;
    }

    private BlockPos getTeleportEnd(Context context, BlockPos startPos) {
        double endRange = 20.0;
        BlockPos endPos = startPos.m_121955_((Vec3i)new BlockPos(context.direction.m_82490_(endRange)));
        List<BlockPos> blocksToCheck = MathUtils.getBlocksInLine(startPos, endPos);
        for (BlockPos pos : blocksToCheck) {
            BlockState blockState = this.level.m_8055_(pos);
            if (blockState.m_60795_() && this.level.m_8055_(pos.m_7494_()).m_60795_()) {
                return pos;
            }
            if (!(blockState.m_60734_().m_155943_() < 0.0f)) continue;
            return null;
        }
        return null;
    }

    private void teleportTo(BlockPos teleportPos) {
        Vec3 pos = VecUtils.asVec3(teleportPos).m_82549_(new Vec3(0.5, 0.0, 0.5));
        this.entity.m_6021_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
    }

    private record Context(Vec3 direction, Vec3 position) {
    }
}

