/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.entity.custom.gauntlet;

import com.cerbon.bosses_of_mass_destruction.api.maelstrom.static_utilities.MathUtils;
import com.cerbon.bosses_of_mass_destruction.api.maelstrom.static_utilities.MobUtils;
import com.cerbon.bosses_of_mass_destruction.client.render.IRenderer;
import com.cerbon.bosses_of_mass_destruction.entity.custom.gauntlet.GauntletEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class LaserParticleRenderer
implements IRenderer<GauntletEntity> {
    @Override
    public void render(GauntletEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        if (entity.laserHandler.shouldRenderLaser()) {
            Pair<Vec3, Vec3> beamPos = entity.laserHandler.getLaserRenderPos();
            Vec3 lerpedPos = MathUtils.lerpVec(partialTicks, (Vec3)beamPos.getSecond(), (Vec3)beamPos.getFirst());
            Vec3 beamVel = MathUtils.unNormedDirection((Vec3)beamPos.getSecond(), (Vec3)beamPos.getFirst()).m_82541_().m_82490_(0.1);
            Vec3 laserDir = MathUtils.unNormedDirection(MobUtils.eyePos((Entity)entity), lerpedPos);
            entity.laserHandler.laserChargeParticles.build(MobUtils.eyePos((Entity)entity).m_82549_(laserDir.m_82490_(entity.m_217043_().m_188500_())), beamVel);
        }
    }
}

