/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.api.maelstrom.general.event;

import com.cerbon.bosses_of_mass_destruction.api.maelstrom.general.event.IEvent;
import java.util.function.Supplier;

public class TimedEvent
implements IEvent {
    private final Runnable callback;
    private final int delay;
    private final int duration;
    private final Supplier<Boolean> shouldCancel;
    private int age;

    public TimedEvent(Runnable callback, int delay, int duration, Supplier<Boolean> shouldCancel) {
        this.callback = callback;
        this.delay = delay;
        this.duration = duration;
        this.shouldCancel = shouldCancel;
        this.age = 0;
    }

    public TimedEvent(Runnable callback, int delay) {
        this(callback, delay, 1, () -> false);
    }

    @Override
    public boolean shouldDoEvent() {
        return this.age++ >= this.delay && this.shouldCancel.get() == false;
    }

    @Override
    public void doEvent() {
        this.callback.run();
    }

    @Override
    public boolean shouldRemoveEvent() {
        return this.shouldCancel.get() != false || this.age >= this.delay + this.duration;
    }

    @Override
    public int tickSize() {
        return 1;
    }
}

