/*
 * Decompiled with CFR 0.152.
 */
package com.jtorleonstudios.libraryferret.gui;

import com.jtorleonstudios.libraryferret.gui.AbstractScreen;
import com.jtorleonstudios.libraryferret.utils.Color;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractUI
extends AbstractContainerEventHandler
implements Widget,
NarratableEntry {
    public final AbstractScreen parent;
    public int x;
    public int y;
    public int width;
    public int height;
    public int left;
    public int right;
    public int top;
    public int bottom;

    public AbstractUI(AbstractScreen parent, int x, int y, int width, int height) {
        this.parent = parent;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.left = this.x;
        this.top = this.y;
        this.right = this.x + this.width;
        this.bottom = this.y + this.height;
    }

    public List<? extends GuiEventListener> m_6702_() {
        return Collections.emptyList();
    }

    public final boolean testAABB(double mouseX, double mouseY) {
        return mouseX >= (double)this.left && mouseX <= (double)this.right && mouseY >= (double)this.top && mouseY <= (double)this.bottom;
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput p_169152_) {
    }

    public void tick() {
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return super.m_5953_(mouseX, mouseY) || this.testAABB(mouseX, mouseY);
    }

    public final void renderBackground() {
        Tesselator t = Tesselator.m_85913_();
        BufferBuilder b = t.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93096_);
        b.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        b.m_5483_((double)this.left, (double)this.bottom, 0.0).m_7421_((float)this.left / 32.0f, (float)this.bottom / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
        b.m_5483_((double)this.right, (double)this.bottom, 0.0).m_7421_((float)this.right / 32.0f, (float)this.bottom / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
        b.m_5483_((double)this.right, (double)this.top, 0.0).m_7421_((float)this.right / 32.0f, (float)this.top / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
        b.m_5483_((double)this.left, (double)this.top, 0.0).m_7421_((float)this.left / 32.0f, (float)this.top / 32.0f).m_6122_(32, 32, 32, 255).m_5752_();
        t.m_85914_();
        RenderSystem.m_69461_();
    }

    public final void renderTexts(List<String> texts, PoseStack matrix, int x, int y, int color) {
        float ry = y;
        for (String v : texts) {
            this.parent.getFontRenderer().m_92750_(matrix, v, (float)x, ry, 0xFFFFFF);
            ry += (float)this.parent.getLineHeight();
        }
    }

    public final List<String> resizeTextToWidth(String text) {
        List data = this.parent.getFontRenderer().m_92865_().m_92432_(text, this.width - this.width / 8, Style.f_131099_);
        ArrayList<String> lines = new ArrayList<String>();
        for (FormattedText v : data) {
            lines.add(v.getString().replaceAll("\n", "").replaceAll("\r", ""));
        }
        return lines;
    }

    public final void fillDebug(PoseStack matrix) {
        AbstractUI.m_93172_((PoseStack)matrix, (int)this.left, (int)this.top, (int)this.right, (int)this.bottom, (int)Color.RED);
    }
}

