/*
 * Decompiled with CFR 0.152.
 */
package com.jtorleonstudios.libraryferret;

import com.jtorleonstudios.libraryferret.LibraryFerretClient;
import com.jtorleonstudios.libraryferret.blocks.Blocks;
import com.jtorleonstudios.libraryferret.conf.Configuration;
import com.jtorleonstudios.libraryferret.conf.Props;
import com.jtorleonstudios.libraryferret.effect.StatusEffects;
import com.jtorleonstudios.libraryferret.items.Items;
import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Mod(value="libraryferret")
public class LibraryFerret {
    public static boolean isLOADED = false;
    public static final String MOD_ID = "libraryferret";
    public static final Logger LOGGER = LogManager.getLogger();
    private static final Props ENABLED_FERRET_ITEM_GROUP = Props.create("creative", "enable_item_group_ferret", false);
    public static final Configuration CONF = new Configuration("libraryferret", ENABLED_FERRET_ITEM_GROUP);
    public static Optional<CreativeModeTab> FERRET_ITEM_GROUP = Optional.empty();

    public LibraryFerret() {
        isLOADED = false;
        LOGGER.info("Initialize mod Library Ferret");
        this.setupOptionalFieldByConfiguration();
        IEventBus e = FMLJavaModLoadingContext.get().getModEventBus();
        StatusEffects.registerEffect(e);
        Items.registerItems(e);
        Blocks.registerBlocks(e);
        e.addListener(this::doCommonStuff);
        e.addListener(this::doClientStuff);
        isLOADED = true;
        LOGGER.info("Initialized mod Library Ferret");
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> LibraryFerretClient::register);
    }

    private void doCommonStuff(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {});
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)Blocks.UNBREAKABLE_IRON_BEACON.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)Blocks.UNBREAKABLE_GOLD_BEACON.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)Blocks.UNBREAKABLE_EMERALD_BEACON.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)Blocks.UNBREAKABLE_DIAMOND_BEACON.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)Blocks.UNBREAKABLE_NETHERITE_BEACON.get()), (RenderType)RenderType.m_110463_());
        });
    }

    public static boolean isLoaded() {
        return isLOADED;
    }

    public static <SP extends StructurePlacement> StructurePlacementType<SP> registerPlacementType(ResourceLocation identifier, Codec<SP> codec) {
        return (StructurePlacementType)Registry.m_122965_((Registry)Registry.f_205930_, (ResourceLocation)identifier, () -> codec);
    }

    public static <SP extends StructurePlacement> RegistryObject<StructurePlacementType<SP>> registerPlacementType(DeferredRegister<StructurePlacementType<?>> def, String identifier, Codec<SP> codec) {
        return def.register(identifier, () -> () -> codec);
    }

    private void setupOptionalFieldByConfiguration() {
        if (CONF.getBoolOrDefault(ENABLED_FERRET_ITEM_GROUP)) {
            FERRET_ITEM_GROUP = Optional.of(new CreativeModeTab("libraryferret.libraryferret"){

                @NotNull
                public ItemStack m_6976_() {
                    return new ItemStack((ItemLike)net.minecraft.world.level.block.Blocks.f_50087_);
                }
            });
        }
    }
}

