/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.vinery.util;

import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import satisfyu.vinery.mixin.OrderedTextToolTipAccessor;
import satisfyu.vinery.util.OrderedTextToTextVisitor;

public class TooltipHelper {
    private static boolean shouldFlip = false;

    public static void newFix(List<ClientTooltipComponent> components, Font textRenderer, int x, int width) {
        shouldFlip = false;
        int forcedWidth = 0;
        for (ClientTooltipComponent component : components) {
            int width2;
            if (component instanceof ClientTextTooltip || (width2 = component.m_142069_(textRenderer)) <= forcedWidth) continue;
            forcedWidth = width2;
        }
        int maxWidth = width - 20 - x;
        if (forcedWidth > maxWidth || maxWidth < 100) {
            shouldFlip = true;
            maxWidth = x - 28;
        }
        TooltipHelper.wrapNewLines(components);
        TooltipHelper.wrapLongLines(components, textRenderer, maxWidth);
    }

    public static int shouldFlip(List<ClientTooltipComponent> components, Font textRenderer, int x) {
        int maxWidth = 0;
        for (ClientTooltipComponent tooltipComponent : components) {
            int newWidth = tooltipComponent.m_142069_(textRenderer);
            if (newWidth <= maxWidth) continue;
            maxWidth = newWidth;
        }
        int renderX = x + 12;
        if (shouldFlip) {
            renderX -= 28 + maxWidth;
        }
        return renderX;
    }

    private static void wrapLongLines(List<ClientTooltipComponent> components, Font textRenderer, int maxSize) {
        for (int i = 0; i < components.size(); ++i) {
            ClientTooltipComponent clientTooltipComponent = components.get(i);
            if (!(clientTooltipComponent instanceof ClientTextTooltip)) continue;
            ClientTextTooltip orderedTextTooltipComponent = (ClientTextTooltip)clientTooltipComponent;
            Component text = OrderedTextToTextVisitor.get(((OrderedTextToolTipAccessor)orderedTextTooltipComponent).getText());
            List<ClientTooltipComponent> wrapped = textRenderer.m_92923_((FormattedText)text, maxSize).stream().map(ClientTooltipComponent::m_169948_).toList();
            components.remove(i);
            components.addAll(i, wrapped);
        }
    }

    private static void wrapNewLines(List<ClientTooltipComponent> components) {
        block0: for (int i = 0; i < components.size(); ++i) {
            ClientTooltipComponent clientTooltipComponent = components.get(i);
            if (!(clientTooltipComponent instanceof ClientTextTooltip)) continue;
            ClientTextTooltip orderedTextTooltipComponent = (ClientTextTooltip)clientTooltipComponent;
            Component text = OrderedTextToTextVisitor.get(((OrderedTextToolTipAccessor)orderedTextTooltipComponent).getText());
            List children = text.m_7360_();
            for (int j = 0; j < children.size() - 1; ++j) {
                String code = ((Component)children.get(j)).getString() + ((Component)children.get(j + 1)).getString();
                if (!code.equals("\\n")) continue;
                components.set(i, ClientTooltipComponent.m_169948_((FormattedCharSequence)TooltipHelper.textWithChildren(children, 0, j).m_7532_()));
                components.add(i + 1, ClientTooltipComponent.m_169948_((FormattedCharSequence)TooltipHelper.textWithChildren(children, j + 2, children.size()).m_7532_()));
                continue block0;
            }
        }
    }

    private static Component textWithChildren(List<Component> children, int from, int end) {
        MutableComponent text = Component.m_237113_((String)"");
        for (int i = from; i < end; ++i) {
            text.m_7220_(children.get(i));
        }
        return text;
    }
}

