/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.vinery.block.storage;

import de.cristelknight.doapi.common.block.StorageBlock;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import satisfyu.vinery.registry.VineryStorageTypes;
import satisfyu.vinery.util.GeneralUtil;
import satisfyu.vinery.util.VineryTags;

public class FlowerBoxBlock
extends StorageBlock {
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.9375, (double)0.0, (double)0.5625, (double)1.0, (double)0.375, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.5625, (double)0.0625, (double)0.375, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.5625, (double)0.9375, (double)0.375, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.9375, (double)0.9375, (double)0.375, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.625, (double)0.9375, (double)0.3125, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    };
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
            map.put(direction, GeneralUtil.rotateShape(Direction.NORTH, direction, voxelShapeSupplier.get()));
        }
    });

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.m_61143_((Property)f_54117_));
    }

    public FlowerBoxBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_6144_()) {
            return InteractionResult.PASS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public int size() {
        return 2;
    }

    public ResourceLocation type() {
        return VineryStorageTypes.FLOWER_BOX;
    }

    public Direction[] unAllowedDirections() {
        return new Direction[]{Direction.DOWN};
    }

    public boolean canInsertStack(ItemStack stack) {
        return stack.m_204117_(VineryTags.SMALL_FLOWER);
    }

    public int getSection(Float x, Float y) {
        if ((double)x.floatValue() < 0.5) {
            return 0;
        }
        return 1;
    }

    public void m_5871_(ItemStack itemStack, BlockGetter world, List<Component> tooltip, TooltipFlag tooltipContext) {
        tooltip.add((Component)Component.m_237115_((String)"block.vinery.canbeplaced.tooltip").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
    }
}

