/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.vinery.block.stem;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import satisfyu.vinery.block.grape.GrapeType;
import satisfyu.vinery.block.stem.StemBlock;
import satisfyu.vinery.item.GrapeBushSeedItem;

public class LatticeStemBlock
extends StemBlock {
    private static final VoxelShape LATTICE_SHAPE_N = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape LATTICE_SHAPE_E = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape LATTICE_SHAPE_S = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape LATTICE_SHAPE_W = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public LatticeStemBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.EAST -> LATTICE_SHAPE_E;
            case Direction.SOUTH -> LATTICE_SHAPE_S;
            case Direction.WEST -> LATTICE_SHAPE_W;
            default -> LATTICE_SHAPE_N;
        };
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction side = ctx.m_43719_();
        BlockState blockState = side != Direction.DOWN && side != Direction.UP ? (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_43719_()) : (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
        if (blockState.m_60710_((LevelReader)ctx.m_43725_(), ctx.m_8083_())) {
            return blockState;
        }
        return null;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        GrapeBushSeedItem seed;
        if (hand == InteractionHand.OFF_HAND) {
            return super.m_6227_(state, world, pos, player, hand, hit);
        }
        ItemStack stack = player.m_21120_(hand);
        int age = (Integer)state.m_61143_((Property)AGE);
        if (age > 0 && stack.m_41720_() == Items.f_42574_) {
            stack.m_41622_(1, (LivingEntity)player, player2 -> player2.m_21190_(player.m_7655_()));
            if (age > 2) {
                this.dropGrapes(world, state, pos);
            }
            this.dropGrapeSeeds(world, state, pos);
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)), 3);
            world.m_5594_(player, pos, SoundEvents.f_12455_, SoundSource.AMBIENT, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        Item item = stack.m_41720_();
        if (item instanceof GrapeBushSeedItem && (seed = (GrapeBushSeedItem)item).getType().isLattice() && age == 0) {
            world.m_7731_(pos, this.withAge(state, 1, seed.getType()), 3);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            world.m_5594_(player, pos, SoundEvents.f_12456_, SoundSource.AMBIENT, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (age > 2) {
            stack.m_41622_(1, (LivingEntity)player, player2 -> player2.m_21190_(player.m_7655_()));
            this.dropGrapes(world, state, pos);
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(1)), 3);
            world.m_5594_(player, pos, SoundEvents.f_12455_, SoundSource.AMBIENT, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int i;
        if (!this.isMature(state) && (Integer)state.m_61143_((Property)AGE) > 0 && world.m_45524_(pos, 0) >= 9 && (i = ((Integer)state.m_61143_((Property)AGE)).intValue()) < 4) {
            world.m_7731_(pos, this.withAge(state, i + 1, (GrapeType)state.m_61143_((Property)GRAPE)), 2);
        }
        super.m_213898_(state, world, pos, random);
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            if ((Integer)state.m_61143_((Property)AGE) > 0) {
                this.dropGrapeSeeds((Level)world, state, pos);
            }
            if ((Integer)state.m_61143_((Property)AGE) > 2) {
                this.dropGrapes((Level)world, state, pos);
            }
            world.m_46961_(pos, true);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        VoxelShape shape;
        return Block.m_49918_((VoxelShape)shape, (Direction)(switch (((Direction)state.m_61143_((Property)FACING)).m_122424_()) {
            case Direction.EAST -> {
                shape = world.m_8055_(pos.m_122029_()).m_60808_((BlockGetter)world, pos.m_122029_());
                yield Direction.WEST;
            }
            case Direction.SOUTH -> {
                shape = world.m_8055_(pos.m_122019_()).m_60808_((BlockGetter)world, pos.m_122019_());
                yield Direction.NORTH;
            }
            case Direction.WEST -> {
                shape = world.m_8055_(pos.m_122024_()).m_60808_((BlockGetter)world, pos.m_122024_());
                yield Direction.EAST;
            }
            default -> {
                shape = world.m_8055_(pos.m_122012_()).m_60808_((BlockGetter)world, pos.m_122012_());
                yield Direction.SOUTH;
            }
        }));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            world.m_186460_(pos, (Block)this, 1);
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public void m_5871_(ItemStack itemStack, BlockGetter world, List<Component> tooltip, TooltipFlag tooltipContext) {
        tooltip.add((Component)Component.m_237115_((String)"block.vinery.lattice.tooltip").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"item.vinery.lattice2.tooltip"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.vinery.faucet.tooltip"));
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }
}

