/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.vinery.block.grape;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import satisfyu.vinery.block.grape.GrapeType;

public class GrapeBush
extends BushBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private final int chance;
    public final GrapeType type;

    public GrapeBush(BlockBehaviour.Properties settings, GrapeType type) {
        this(settings, type, 5);
    }

    public GrapeBush(BlockBehaviour.Properties settings, GrapeType type, int chance) {
        super(settings);
        this.chance = chance;
        this.type = type;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this.getType().getSeeds());
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean bl;
        int i = (Integer)state.m_61143_((Property)AGE);
        boolean bl2 = bl = i == 3;
        if (!bl && player.m_21120_(hand).m_150930_(Items.f_42499_)) {
            return InteractionResult.PASS;
        }
        if (i > 1) {
            int x = world.f_46441_.m_188503_(2);
            GrapeBush.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.getGrapeType().m_41720_(), x + (bl ? 1 : 0)));
            world.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + world.f_46441_.m_188501_() * 0.4f);
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int i = (Integer)state.m_61143_((Property)AGE);
        if (i < 3 && random.m_188503_(this.chance) == 0 && this.canGrowPlace((LevelReader)world, pos, state)) {
            BlockState blockState = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            world.m_7731_(pos, blockState, 2);
            world.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)blockState));
        }
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) < 3;
    }

    public boolean m_7370_(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, boolean bl) {
        return (Integer)blockState.m_61143_((Property)AGE) < 3;
    }

    public boolean m_214167_(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean canGrowPlace(LevelReader world, BlockPos blockPos, BlockState blockState) {
        return world.m_45524_(blockPos, 0) > 9;
    }

    public boolean m_7898_(BlockState blockState, LevelReader world, BlockPos blockPos) {
        return this.canGrowPlace(world, blockPos, blockState) && this.m_6266_(world.m_8055_(blockPos.m_7495_()), (BlockGetter)world, blockPos);
    }

    protected boolean m_6266_(BlockState floor, BlockGetter world, BlockPos pos) {
        return floor.m_60804_(world, pos);
    }

    public GrapeType getType() {
        return this.type;
    }

    public ItemStack getGrapeType() {
        return new ItemStack((ItemLike)this.getType().getFruit());
    }

    public void m_214148_(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        int i = Math.min(3, (Integer)state.m_61143_((Property)AGE) + 1);
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }
}

