/*
 * Decompiled with CFR 0.152.
 */
package net.satisfyu.meadow.registry;

import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.animal.Sheep;
import net.satisfyu.meadow.Meadow;
import net.satisfyu.meadow.entity.bear.BrownBearEntity;
import net.satisfyu.meadow.entity.buffalo.WaterBuffaloEntity;
import net.satisfyu.meadow.entity.chicken.MeadowChickenEntity;
import net.satisfyu.meadow.entity.cow.albino_cow.AlbinoCowEntity;
import net.satisfyu.meadow.entity.cow.cookie_cow.CookieCowEntity;
import net.satisfyu.meadow.entity.cow.cream_cow.CreamCowEntity;
import net.satisfyu.meadow.entity.cow.dairy_cow.DairyCowEntity;
import net.satisfyu.meadow.entity.cow.dark_cow.DarkCowEntity;
import net.satisfyu.meadow.entity.cow.pinto_cow.PintoCowEntity;
import net.satisfyu.meadow.entity.cow.shearable.highland_cattle.HighlandCattleEntity;
import net.satisfyu.meadow.entity.cow.shearable.umbra.UmbraCowEntity;
import net.satisfyu.meadow.entity.cow.shearable.warped.WarpedCowEntity;
import net.satisfyu.meadow.entity.cow.sunset_cow.SunsetCowEntity;
import net.satisfyu.meadow.entity.sheep.flecked.FleckedSheepEntity;
import net.satisfyu.meadow.entity.sheep.fuzzy.FuzzySheepEntity;
import net.satisfyu.meadow.entity.sheep.horned.HornedSheepEntity;
import net.satisfyu.meadow.entity.sheep.inky.InkySheepEntity;
import net.satisfyu.meadow.entity.sheep.long_nosed.LongNosedSheepEntity;
import net.satisfyu.meadow.entity.sheep.patched.PatchedSheepEntity;
import net.satisfyu.meadow.entity.sheep.rocky.RockySheepEntity;

public class EntityRegistry {
    private static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"meadow", (ResourceKey)Registry.f_122903_);
    public static final RegistrySupplier<EntityType<AlbinoCowEntity>> ALBINO_COW = EntityRegistry.create("albino_cow", () -> EntityType.Builder.m_20704_(AlbinoCowEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(1.4f, 1.4f).m_20712_(new ResourceLocation("meadow", "albino_cow").toString()));
    public static final RegistrySupplier<EntityType<BrownBearEntity>> BROWN_BEAR = EntityRegistry.create("brown_bear", () -> EntityType.Builder.m_20704_(BrownBearEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(1.4f, 1.4f).m_20712_(new ResourceLocation("meadow", "brown_bear").toString()));
    public static final RegistrySupplier<EntityType<WaterBuffaloEntity>> WATER_BUFFALO = EntityRegistry.create("water_buffalo", () -> EntityType.Builder.m_20704_(WaterBuffaloEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.4f).m_20712_(new ResourceLocation("meadow", "water_buffalo").toString()));
    public static final RegistrySupplier<EntityType<CookieCowEntity>> COOKIE_COW = EntityRegistry.create("cookie_cow", () -> EntityType.Builder.m_20704_(CookieCowEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.4f).m_20712_(new ResourceLocation("meadow", "cookie_cow").toString()));
    public static final RegistrySupplier<EntityType<CreamCowEntity>> CREAM_COW = EntityRegistry.create("cream_cow", () -> EntityType.Builder.m_20704_(CreamCowEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.4f).m_20712_(new ResourceLocation("meadow", "cream_cow").toString()));
    public static final RegistrySupplier<EntityType<DairyCowEntity>> DAIRY_COW = EntityRegistry.create("dairy_cow", () -> EntityType.Builder.m_20704_(DairyCowEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.4f).m_20712_(new ResourceLocation("meadow", "dairy_cow").toString()));
    public static final RegistrySupplier<EntityType<DarkCowEntity>> DARK_COW = EntityRegistry.create("dark_cow", () -> EntityType.Builder.m_20704_(DarkCowEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.4f).m_20712_(new ResourceLocation("meadow", "dark_cow").toString()));
    public static final RegistrySupplier<EntityType<PintoCowEntity>> PINTO_COW = EntityRegistry.create("pinto_cow", () -> EntityType.Builder.m_20704_(PintoCowEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.4f).m_20712_(new ResourceLocation("meadow", "pinto_cow").toString()));
    public static final RegistrySupplier<EntityType<SunsetCowEntity>> SUNSET_COW = EntityRegistry.create("sunset_cow", () -> EntityType.Builder.m_20704_(SunsetCowEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.4f).m_20712_(new ResourceLocation("meadow", "sunset_cow").toString()));
    public static final RegistrySupplier<EntityType<HighlandCattleEntity>> HIGHLAND_CATTLE = EntityRegistry.create("highland_cattle", () -> EntityType.Builder.m_20704_(HighlandCattleEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.4f).m_20712_(new ResourceLocation("meadow", "highland_cattle").toString()));
    public static final RegistrySupplier<EntityType<UmbraCowEntity>> UMBRA_COW = EntityRegistry.create("umbra_cow", () -> EntityType.Builder.m_20704_(UmbraCowEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.4f).m_20712_(new ResourceLocation("meadow", "umbra_cow").toString()));
    public static final RegistrySupplier<EntityType<WarpedCowEntity>> WARPED_COW = EntityRegistry.create("warped_cow", () -> EntityType.Builder.m_20704_(WarpedCowEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.4f).m_20712_(new ResourceLocation("meadow", "warped_cow").toString()));
    public static final RegistrySupplier<EntityType<FleckedSheepEntity>> FLECKED_SHEEP = EntityRegistry.create("flecked_sheep", () -> EntityType.Builder.m_20704_(FleckedSheepEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.3f).m_20712_(new ResourceLocation("meadow", "flecked_sheep").toString()));
    public static final RegistrySupplier<EntityType<FuzzySheepEntity>> FUZZY_SHEEP = EntityRegistry.create("fuzzy_sheep", () -> EntityType.Builder.m_20704_(FuzzySheepEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.3f).m_20712_(new ResourceLocation("meadow", "fuzzy_sheep").toString()));
    public static final RegistrySupplier<EntityType<HornedSheepEntity>> HORNED_SHEEP = EntityRegistry.create("horned_sheep", () -> EntityType.Builder.m_20704_(HornedSheepEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.3f).m_20712_(new ResourceLocation("meadow", "horned_sheep").toString()));
    public static final RegistrySupplier<EntityType<InkySheepEntity>> INKY_SHEEP = EntityRegistry.create("inky_sheep", () -> EntityType.Builder.m_20704_(InkySheepEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.3f).m_20712_(new ResourceLocation("meadow", "inky_sheep").toString()));
    public static final RegistrySupplier<EntityType<LongNosedSheepEntity>> LONG_NOSED_SHEEP = EntityRegistry.create("long_nosed_sheep", () -> EntityType.Builder.m_20704_(LongNosedSheepEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.3f).m_20712_(new ResourceLocation("meadow", "long_nosed_sheep").toString()));
    public static final RegistrySupplier<EntityType<PatchedSheepEntity>> PATCHED_SHEEP = EntityRegistry.create("patched_sheep", () -> EntityType.Builder.m_20704_(PatchedSheepEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.3f).m_20712_(new ResourceLocation("meadow", "patched_sheep").toString()));
    public static final RegistrySupplier<EntityType<RockySheepEntity>> ROCKY_SHEEP = EntityRegistry.create("rocky_sheep", () -> EntityType.Builder.m_20704_(RockySheepEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.3f).m_20712_(new ResourceLocation("meadow", "rocky_sheep").toString()));
    public static final RegistrySupplier<EntityType<MeadowChickenEntity>> MEADOW_CHICKEN = EntityRegistry.create("chicken_1", () -> EntityType.Builder.m_20704_(MeadowChickenEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.4f, 0.7f).m_20712_(new ResourceLocation("meadow", "chicken_1").toString()));

    public static void init() {
        Meadow.LOGGER.debug("Registering Mod Entities for meadow");
        ENTITY_TYPES.register();
        EntityAttributeRegistry.register(BROWN_BEAR, PolarBear::m_29560_);
        EntityRegistry.registerChicken(MEADOW_CHICKEN);
        EntityRegistry.registerSheep(FLECKED_SHEEP);
        EntityRegistry.registerSheep(FUZZY_SHEEP);
        EntityRegistry.registerSheep(HORNED_SHEEP);
        EntityRegistry.registerSheep(INKY_SHEEP);
        EntityRegistry.registerSheep(LONG_NOSED_SHEEP);
        EntityRegistry.registerSheep(PATCHED_SHEEP);
        EntityRegistry.registerSheep(ROCKY_SHEEP);
        EntityRegistry.registerCow(WARPED_COW);
        EntityRegistry.registerCow(HIGHLAND_CATTLE);
        EntityRegistry.registerCow(UMBRA_COW);
        EntityRegistry.registerCow(COOKIE_COW);
        EntityRegistry.registerCow(ALBINO_COW);
        EntityRegistry.registerCow(CREAM_COW);
        EntityRegistry.registerCow(DAIRY_COW);
        EntityRegistry.registerCow(WATER_BUFFALO);
        EntityRegistry.registerCow(DARK_COW);
        EntityRegistry.registerCow(PINTO_COW);
        EntityRegistry.registerCow(SUNSET_COW);
    }

    public static void registerCow(Supplier<? extends EntityType<? extends Animal>> typeSupplier) {
        EntityAttributeRegistry.register(typeSupplier, Cow::m_28307_);
    }

    public static void registerSheep(Supplier<? extends EntityType<? extends Animal>> typeSupplier) {
        EntityAttributeRegistry.register(typeSupplier, Sheep::m_29873_);
    }

    public static void registerChicken(Supplier<? extends EntityType<? extends Animal>> typeSupplier) {
        EntityAttributeRegistry.register(typeSupplier, Chicken::m_28263_);
    }

    public static <T extends EntityType<?>> RegistrySupplier<T> create(String path, Supplier<T> type) {
        return ENTITY_TYPES.register(new ResourceLocation("meadow", path), type);
    }
}

