/*
 * Decompiled with CFR 0.152.
 */
package net.satisfyu.meadow.client.recipebook.group;

import com.google.common.collect.ImmutableList;
import de.cristelknight.doapi.client.recipebook.IRecipeBookGroup;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.satisfyu.meadow.Meadow;
import net.satisfyu.meadow.recipes.cooking.CookingCauldronRecipe;
import net.satisfyu.meadow.registry.ObjectRegistry;

@OnlyIn(value=Dist.CLIENT)
public enum CookingCauldronRecipeBookGroup implements IRecipeBookGroup
{
    SEARCH(new ItemStack((ItemLike)Items.f_42522_)),
    MEADOW(new ItemStack((ItemLike)ObjectRegistry.RENNET.get())),
    MISC(new ItemStack((ItemLike)Items.f_42580_));

    public static final List<IRecipeBookGroup> CAULDRON_GROUPS;
    private final List<ItemStack> icons;

    private CookingCauldronRecipeBookGroup(ItemStack ... entries) {
        this.icons = ImmutableList.copyOf((Object[])entries);
    }

    public boolean fitRecipe(Recipe<?> recipe) {
        if (recipe instanceof CookingCauldronRecipe) {
            CookingCauldronRecipe cookingCauldronRecipe = (CookingCauldronRecipe)recipe;
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case SEARCH -> true;
                case MEADOW -> {
                    if (recipe.m_8043_().m_41720_().m_41471_() == Meadow.MEADOW_TAB) {
                        yield true;
                    }
                    yield false;
                }
                case MISC -> recipe.m_8043_().m_41720_().m_41471_() != Meadow.MEADOW_TAB;
            };
        }
        return false;
    }

    public List<ItemStack> getIcons() {
        return this.icons;
    }

    static {
        CAULDRON_GROUPS = ImmutableList.of((Object)((Object)SEARCH), (Object)((Object)MEADOW), (Object)((Object)MISC));
    }
}

