/*
 * Decompiled with CFR 0.152.
 */
package net.satisfyu.meadow.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfyu.meadow.block.MeadowBlockProperties;
import net.satisfyu.meadow.util.LineConnectingType;
import org.jetbrains.annotations.Nullable;

public class LineConnectingBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<LineConnectingType> TYPE = MeadowBlockProperties.LINE_CONNECTING_TYPE;

    public LineConnectingBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(TYPE, (Comparable)((Object)LineConnectingType.NONE)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_8125_().m_122424_();
        BlockState blockState = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing);
        Level world = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        return switch (facing) {
            case Direction.EAST -> (BlockState)blockState.m_61124_(TYPE, (Comparable)((Object)this.getType(blockState, world.m_8055_(clickedPos.m_122019_()), world.m_8055_(clickedPos.m_122012_()))));
            case Direction.SOUTH -> (BlockState)blockState.m_61124_(TYPE, (Comparable)((Object)this.getType(blockState, world.m_8055_(clickedPos.m_122024_()), world.m_8055_(clickedPos.m_122029_()))));
            case Direction.WEST -> (BlockState)blockState.m_61124_(TYPE, (Comparable)((Object)this.getType(blockState, world.m_8055_(clickedPos.m_122012_()), world.m_8055_(clickedPos.m_122019_()))));
            default -> (BlockState)blockState.m_61124_(TYPE, (Comparable)((Object)this.getType(blockState, world.m_8055_(clickedPos.m_122029_()), world.m_8055_(clickedPos.m_122024_()))));
        };
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        if (world.f_46443_) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        LineConnectingType type = switch (facing) {
            case Direction.EAST -> this.getType(state, world.m_8055_(pos.m_122019_()), world.m_8055_(pos.m_122012_()));
            case Direction.SOUTH -> this.getType(state, world.m_8055_(pos.m_122024_()), world.m_8055_(pos.m_122029_()));
            case Direction.WEST -> this.getType(state, world.m_8055_(pos.m_122012_()), world.m_8055_(pos.m_122019_()));
            default -> this.getType(state, world.m_8055_(pos.m_122029_()), world.m_8055_(pos.m_122024_()));
        };
        if (state.m_61143_(TYPE) != type) {
            state = (BlockState)state.m_61124_(TYPE, (Comparable)((Object)type));
        }
        world.m_7731_(pos, state, 3);
    }

    public LineConnectingType getType(BlockState state, BlockState left, BlockState right) {
        boolean shape_right_same;
        boolean shape_left_same = left.m_60734_() == state.m_60734_() && left.m_61143_((Property)FACING) == state.m_61143_((Property)FACING);
        boolean bl = shape_right_same = right.m_60734_() == state.m_60734_() && right.m_61143_((Property)FACING) == state.m_61143_((Property)FACING);
        if (shape_left_same && shape_right_same) {
            return LineConnectingType.MIDDLE;
        }
        if (shape_left_same) {
            return LineConnectingType.LEFT;
        }
        if (shape_right_same) {
            return LineConnectingType.RIGHT;
        }
        return LineConnectingType.NONE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, TYPE});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

