/*
 * Decompiled with CFR 0.152.
 */
package satisfy.bakery.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import satisfy.bakery.registry.RecipeTypeRegistry;
import satisfy.bakery.util.GeneralUtil;

public class StoveRecipe
implements Recipe<Container> {
    protected final ResourceLocation id;
    protected final NonNullList<Ingredient> inputs;
    protected final ItemStack output;
    protected final float experience;

    public StoveRecipe(ResourceLocation id, NonNullList<Ingredient> inputs, ItemStack output, float experience) {
        this.id = id;
        this.inputs = inputs;
        this.output = output;
        this.experience = experience;
    }

    public boolean m_5818_(Container inventory, Level world) {
        return GeneralUtil.matchesRecipe(inventory, this.inputs, 1, 3);
    }

    public ItemStack m_5874_(Container container) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.output.m_41777_();
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public float getExperience() {
        return this.experience;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeTypeRegistry.STOVE_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeTypeRegistry.STOVE_RECIPE_TYPE.get();
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<StoveRecipe> {
        public StoveRecipe fromJson(ResourceLocation id, JsonObject json) {
            NonNullList<Ingredient> ingredients = GeneralUtil.deserializeIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for Stove Recipe");
            }
            if (ingredients.size() > 3) {
                throw new JsonParseException("Too many ingredients for Stove Recipe");
            }
            ItemStack outputStack = ShapedRecipe.m_151274_((JsonObject)json);
            float xp = GsonHelper.m_13820_((JsonObject)json, (String)"experience", (float)0.0f);
            return new StoveRecipe(id, ingredients, outputStack, xp);
        }

        public StoveRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            NonNullList ingredients = NonNullList.m_122780_((int)buf.m_130242_(), (Object)Ingredient.f_43901_);
            ingredients.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buf));
            ItemStack output = buf.m_130267_();
            float xp = buf.readFloat();
            return new StoveRecipe(id, (NonNullList<Ingredient>)ingredients, output, xp);
        }

        public void toNetwork(FriendlyByteBuf packet, StoveRecipe recipe) {
            packet.m_130130_(recipe.inputs.size());
            recipe.inputs.forEach(entry -> entry.m_43923_(packet));
            packet.m_130055_(recipe.output);
            packet.writeFloat(recipe.experience);
        }
    }
}

