/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.serial.wrapper;

import dev.xkmc.l2library.util.code.LazyExc;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RecordCache {
    private static final Map<Class<?>, RecordCache> CACHE = new ConcurrentHashMap();
    private final LazyExc<Field[]> fields = new LazyExc<Field[]>(() -> {
        Field[] ans;
        for (Field f2 : ans = (Field[])Arrays.stream(cls.getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).toArray(Field[]::new)) {
            f2.setAccessible(true);
        }
        return ans;
    });
    private final LazyExc<Constructor<?>> factory = new LazyExc<Constructor>(() -> {
        Class[] clss = (Class[])Arrays.stream(this.fields.get()).map(Field::getType).toArray(Class[]::new);
        Constructor ans = cls.getConstructor(clss);
        ans.setAccessible(true);
        return ans;
    });

    public static RecordCache get(Class<?> cls) {
        return CACHE.computeIfAbsent(cls, RecordCache::new);
    }

    private RecordCache(Class<?> cls) {
    }

    public Field[] getFields() throws Exception {
        return this.fields.get();
    }

    public Object create(Object[] objs) throws Exception {
        return this.factory.get().newInstance(objs);
    }
}

