/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.serial.network;

import dev.xkmc.l2library.serial.network.SerialPacketBase;
import dev.xkmc.l2library.serial.network.SimplePacketBase;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketHandler {
    private static final List<PacketHandler> LIST = new ArrayList<PacketHandler>();
    public final ResourceLocation CHANNEL_NAME;
    public final int NETWORK_VERSION;
    public final String NETWORK_VERSION_STR;
    public SimpleChannel channel;
    private final Function<PacketHandler, LoadedPacket<?>>[] values;
    private int index = 0;

    public static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            for (PacketHandler handler : LIST) {
                handler.registerPackets();
            }
        });
    }

    @SafeVarargs
    public PacketHandler(ResourceLocation id, int version, Function<PacketHandler, LoadedPacket<?>> ... values) {
        this.CHANNEL_NAME = id;
        this.NETWORK_VERSION = version;
        this.NETWORK_VERSION_STR = String.valueOf(this.NETWORK_VERSION);
        this.values = values;
        LIST.add(this);
    }

    public <T extends SimplePacketBase> LoadedPacket<T> create(Class<T> type, Function<FriendlyByteBuf, T> factory, NetworkDirection direction) {
        return new LoadedPacket<T>(type, factory, direction);
    }

    public <T extends SerialPacketBase> LoadedPacket<T> create(Class<T> type, NetworkDirection direction) {
        return new LoadedPacket<SerialPacketBase>(type, buf -> SerialPacketBase.serial(type, buf), direction);
    }

    public void toServer(SimplePacketBase packet) {
        this.channel.sendToServer((Object)packet);
    }

    public void toTrackingPlayers(SimplePacketBase packet, Entity e) {
        this.channel.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> e), (Object)packet);
    }

    public void toClientPlayer(SimplePacketBase packet, ServerPlayer e) {
        this.channel.sendTo((Object)packet, e.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
    }

    public void toAllClient(SimplePacketBase packet) {
        this.channel.send(PacketDistributor.ALL.noArg(), (Object)packet);
    }

    public void sendToNear(Level world, BlockPos pos, int range, Object message) {
        this.channel.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)range, (ResourceKey)world.m_46472_())), message);
    }

    private void registerPackets() {
        this.channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)this.CHANNEL_NAME).serverAcceptedVersions(this.NETWORK_VERSION_STR::equals).clientAcceptedVersions(this.NETWORK_VERSION_STR::equals).networkProtocolVersion(() -> this.NETWORK_VERSION_STR).simpleChannel();
        for (Function<PacketHandler, LoadedPacket<?>> packet : this.values) {
            packet.apply(this).register();
        }
    }

    public class LoadedPacket<T extends SimplePacketBase> {
        private final BiConsumer<T, FriendlyByteBuf> encoder = SimplePacketBase::write;
        private final Function<FriendlyByteBuf, T> decoder;
        private final BiConsumer<T, Supplier<NetworkEvent.Context>> handler;
        private final Class<T> type;
        private final NetworkDirection direction;

        private LoadedPacket(Class<T> type, Function<FriendlyByteBuf, T> factory, NetworkDirection direction) {
            this.decoder = factory;
            this.handler = SimplePacketBase::handle;
            this.type = type;
            this.direction = direction;
        }

        private void register() {
            PacketHandler.this.channel.messageBuilder(this.type, PacketHandler.this.index++, this.direction).encoder(this.encoder).decoder(this.decoder).consumerMainThread(this.handler).add();
        }
    }
}

