/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.serial.config;

import dev.xkmc.l2library.serial.config.ConfigCollect;
import dev.xkmc.l2library.serial.network.BaseConfig;
import dev.xkmc.l2library.serial.wrapper.ClassCache;
import dev.xkmc.l2library.serial.wrapper.FieldCache;
import dev.xkmc.l2library.serial.wrapper.TypeInfo;
import dev.xkmc.l2library.util.code.Wrappers;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;

public class ConfigMerger<T extends BaseConfig>
implements Function<Stream<Map.Entry<String, BaseConfig>>, T> {
    private final ClassCache cache;

    public ConfigMerger(Class<T> cls) {
        this.cache = ClassCache.get(cls);
    }

    public T merge(Stream<Map.Entry<String, BaseConfig>> s) throws Exception {
        List<BaseConfig> list = s.map(e -> (BaseConfig)e.getValue()).toList();
        BaseConfig ans = (BaseConfig)this.cache.create();
        block6: for (FieldCache field : this.cache.getFields()) {
            ConfigCollect collect = field.getConfigAnnotation();
            if (collect == null) continue;
            switch (collect.value()) {
                case OVERWRITE: {
                    int n = list.size();
                    if (n <= 0) continue block6;
                    field.set(ans, field.get(list.get(n - 1)));
                    continue block6;
                }
                case COLLECT: {
                    TypeInfo info = field.toType();
                    assert (Collection.class.isAssignableFrom(info.getAsClass()));
                    Object val = (Collection)info.toCache().create();
                    for (BaseConfig baseConfig : list) {
                        val.addAll((Collection)field.get(baseConfig));
                    }
                    field.set(ans, val);
                    continue block6;
                }
                case MAP_COLLECT: {
                    TypeInfo info = field.toType();
                    TypeInfo sub = info.getGenericType(1);
                    assert (Map.class.isAssignableFrom(info.getAsClass()));
                    Map val = (Map)info.toCache().create();
                    if (Collection.class.isAssignableFrom(sub.getAsClass())) {
                        for (BaseConfig t : list) {
                            map = (Map)field.get(t);
                            for (Map.Entry e2 : map.entrySet()) {
                                ent = e2;
                                if (val.containsKey(ent.getKey())) {
                                    col = (Collection)val.get(ent.getKey());
                                } else {
                                    col = (Collection)sub.toCache().create();
                                    val.put(ent.getKey(), col);
                                }
                                col.addAll((Collection)ent.getValue());
                            }
                        }
                    } else if (Map.class.isAssignableFrom(sub.getAsClass())) {
                        for (BaseConfig t : list) {
                            map = (Map)field.get(t);
                            for (Map.Entry e2 : map.entrySet()) {
                                ent = e2;
                                if (val.containsKey(ent.getKey())) {
                                    col = (Map)val.get(ent.getKey());
                                } else {
                                    col = (Map)sub.toCache().create();
                                    val.put(ent.getKey(), col);
                                }
                                col.putAll((Map)ent.getValue());
                            }
                        }
                    }
                    field.set(ans, val);
                    continue block6;
                }
                case MAP_OVERWRITE: {
                    TypeInfo info = field.toType();
                    assert (Map.class.isAssignableFrom(info.getAsClass()));
                    Object val = (Map)info.toCache().create();
                    for (BaseConfig baseConfig : list) {
                        val.putAll((Map)field.get(baseConfig));
                    }
                    field.set(ans, val);
                }
            }
        }
        return (T)ans;
    }

    @Override
    public T apply(Stream<Map.Entry<String, BaseConfig>> s) {
        return (T)Wrappers.get(() -> this.merge(s));
    }
}

