/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.init;

import dev.xkmc.l2library.base.L2Registrate;
import dev.xkmc.l2library.base.effects.ClientEntityEffectRenderEvents;
import dev.xkmc.l2library.base.effects.EffectSyncEvents;
import dev.xkmc.l2library.base.effects.EffectToClient;
import dev.xkmc.l2library.base.ingredients.EnchantmentIngredient;
import dev.xkmc.l2library.base.ingredients.MobEffectIngredient;
import dev.xkmc.l2library.base.ingredients.PotionIngredient;
import dev.xkmc.l2library.base.tabs.contents.AttributeEntry;
import dev.xkmc.l2library.capability.player.PlayerCapToClient;
import dev.xkmc.l2library.capability.player.PlayerCapabilityEvents;
import dev.xkmc.l2library.capability.player.PlayerCapabilityHolder;
import dev.xkmc.l2library.compat.curio.OpenCuriosPacket;
import dev.xkmc.l2library.compat.curio.TabCuriosCompat;
import dev.xkmc.l2library.idea.infmaze.worldgen.MazeDimension;
import dev.xkmc.l2library.init.L2Client;
import dev.xkmc.l2library.init.L2LibraryConfig;
import dev.xkmc.l2library.init.L2LibraryLangData;
import dev.xkmc.l2library.init.events.GenericEventHandler;
import dev.xkmc.l2library.init.events.attack.AttackEventHandler;
import dev.xkmc.l2library.repack.registrate.providers.ProviderType;
import dev.xkmc.l2library.serial.handler.Handlers;
import dev.xkmc.l2library.serial.network.PacketHandler;
import dev.xkmc.l2library.serial.network.SyncPacket;
import dev.xkmc.l2library.util.raytrace.TargetSetPacket;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="l2library")
public class L2Library {
    public static final String MODID = "l2library";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final L2Registrate REGISTRATE = new L2Registrate("l2library");
    public static final PacketHandler PACKET_HANDLER = new PacketHandler(new ResourceLocation("l2library", "main"), 1, e -> e.create(SyncPacket.class, NetworkDirection.PLAY_TO_CLIENT), e -> e.create(EffectToClient.class, NetworkDirection.PLAY_TO_CLIENT), e -> e.create(PlayerCapToClient.class, NetworkDirection.PLAY_TO_CLIENT), e -> e.create(TargetSetPacket.class, NetworkDirection.PLAY_TO_SERVER), e -> e.create(OpenCuriosPacket.class, NetworkDirection.PLAY_TO_SERVER));

    public L2Library() {
        Handlers.register();
        FMLJavaModLoadingContext ctx = FMLJavaModLoadingContext.get();
        IEventBus bus = ctx.getModEventBus();
        bus.addListener(MazeDimension::register);
        MinecraftForge.EVENT_BUS.register(GenericEventHandler.class);
        MinecraftForge.EVENT_BUS.register(EffectSyncEvents.class);
        MinecraftForge.EVENT_BUS.register(PlayerCapabilityEvents.class);
        MinecraftForge.EVENT_BUS.register(AttackEventHandler.class);
        MinecraftForge.EVENT_BUS.register(ClientEntityEffectRenderEvents.class);
        bus.addListener(L2Library::registerCaps);
        bus.addListener(PacketHandler::setup);
        bus.addListener(L2Library::setup);
        bus.addListener(L2Library::registerRecipeSerializers);
        L2LibraryConfig.init();
        TabCuriosCompat.onStartup();
        REGISTRATE.addDataGenerator(ProviderType.LANG, L2LibraryLangData::genLang);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> L2Client.onCtorClient(bus, MinecraftForge.EVENT_BUS));
    }

    public static void registerCaps(RegisterCapabilitiesEvent event) {
        for (PlayerCapabilityHolder<?> holder : PlayerCapabilityHolder.INTERNAL_MAP.values()) {
            event.register(holder.cls);
        }
    }

    public static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            AttributeEntry.add(() -> Attributes.f_22276_, false, 1000);
            AttributeEntry.add(() -> Attributes.f_22284_, false, 2000);
            AttributeEntry.add(() -> Attributes.f_22285_, false, 3000);
            AttributeEntry.add(() -> Attributes.f_22278_, false, 4000);
            AttributeEntry.add(() -> Attributes.f_22279_, false, 5000);
            AttributeEntry.add(() -> Attributes.f_22281_, false, 6000);
            AttributeEntry.add(() -> Attributes.f_22283_, false, 7000);
            AttributeEntry.add((Supplier<Attribute>)ForgeMod.REACH_DISTANCE, false, 8000);
            AttributeEntry.add((Supplier<Attribute>)ForgeMod.ATTACK_RANGE, false, 9000);
            AttributeEntry.add(() -> Attributes.f_22286_, false, 10000);
        });
    }

    public static void registerRecipeSerializers(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)ForgeRegistries.Keys.RECIPE_SERIALIZERS)) {
            CraftingHelper.register((ResourceLocation)EnchantmentIngredient.INSTANCE.id(), EnchantmentIngredient.INSTANCE);
            CraftingHelper.register((ResourceLocation)PotionIngredient.INSTANCE.id(), PotionIngredient.INSTANCE);
            CraftingHelper.register((ResourceLocation)MobEffectIngredient.INSTANCE.id(), MobEffectIngredient.INSTANCE);
        }
    }
}

