/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.idea.maze.objective;

import dev.xkmc.l2library.idea.maze.objective.MazeCellData;
import dev.xkmc.l2library.idea.maze.objective.MazeGeneralData;

public class ComplexBranchObjective
extends MazeCellData<ComplexBranchObjective, MazeGeneralData> {
    public int count;
    public boolean isLeaf;

    public void fillData(MazeGeneralData global, ComplexBranchObjective[] children) {
        if (children.length == 0) {
            this.isLeaf = true;
            this.count = 0;
        } else if (children.length == 1) {
            this.isLeaf = children[0].isLeaf;
            this.count = children[0].count;
        } else {
            this.count = 0;
            int non_leaf = 0;
            for (ComplexBranchObjective obj : children) {
                this.count += obj.count;
                if (obj.isLeaf) continue;
                ++non_leaf;
            }
            this.count = this.count == 0 ? 1 : (this.count += non_leaf - 1);
        }
    }

    @Override
    public double getResult() {
        return this.count;
    }
}

