/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.idea.maze.generator;

import dev.xkmc.l2library.idea.maze.generator.IRandom;
import dev.xkmc.l2library.idea.maze.generator.MazeConfig;
import java.util.ArrayList;
import java.util.List;

public class MazeGen {
    private final List<State> STATE_LIST = new ArrayList<State>();
    private final MazeConfig config;
    private final Debugger debug;
    public final int[][] ans;
    final int[][] conn;
    final State[][] states;
    public final int r;
    public final int w;
    final IRandom rand;

    private static int[] randArray(int n, IRandom r) {
        int i;
        int[] ans = new int[n];
        if (n <= 1) {
            return ans;
        }
        for (i = 0; i < n; ++i) {
            ans[i] = i;
        }
        for (i = 0; i < n; ++i) {
            int x = r.nextInt(n - 1);
            if (x >= i) {
                ++x;
            }
            int temp = ans[i];
            ans[i] = ans[x];
            ans[x] = temp;
        }
        return ans;
    }

    private static int sign(int x) {
        return x < 0 ? -1 : (x > 0 ? 1 : 0);
    }

    public MazeGen(int rad, IRandom ra, MazeConfig conf, Debugger deb) {
        this.config = conf;
        this.debug = deb;
        this.r = rad;
        this.w = this.r * 2 + 1;
        this.rand = ra;
        this.ans = new int[this.w][this.w];
        this.conn = new int[this.w][this.w];
        this.states = new State[this.w][this.w];
    }

    public void gen() {
        int i;
        this.debug.begin(this);
        this.set(this.states, this.trans(0, 0), new State());
        for (i = 1; i <= this.r; ++i) {
            int stcount = this.STATE_LIST.size();
            StateRim[] rim = this.getStateRim(i);
            int rootCount = 0;
            for (StateRim stateRim : rim) {
                if (!stateRim.state.isRoot()) continue;
                ++rootCount;
            }
            if (i == this.r) {
                rootCount = 1;
            }
            int[] rarr = MazeGen.randArray(rim.length, this.rand);
            for (int j = 0; j < rim.length; ++j) {
                int ind = rarr[j];
                int path = this.config.randPath(i, rim[ind], this.rand, rootCount);
                if (path == 0) {
                    --rootCount;
                }
                rim[ind].path = path;
                if (i < this.r) {
                    rim[ind].loop = this.config.randLoop(i, rim[ind], this.rand);
                }
                rim[ind].seg();
            }
            this.debug.breakpoint("rim " + i + " formed");
            PostRim[] post = this.getPostRim(i);
            for (int j = 0; j < post.length; ++j) {
                State s1;
                State s0;
                if (post[j].state.isRoot() || i != this.r && !this.config.testConn(this.rand, stcount <= post[j].state.getInd()) || (s0 = post[j].state).equals(s1 = post[(j + 1) % post.length].state)) continue;
                int t0 = this.rim(i, post[j].x1);
                int t1 = this.rim(i, post[(j + 1) % post.length].x0);
                this.set(this.conn, t0, this.get(this.conn, t0) | 2);
                this.set(this.conn, t1, this.get(this.conn, t1) | 1);
                s0.set(s1);
            }
            this.debug.breakpoint("rim " + i + " done");
        }
        for (i = 0; i < this.w; ++i) {
            for (int j = 0; j < this.w; ++j) {
                this.fill(i, j);
            }
        }
        this.debug.breakpoint("finish");
    }

    int inner(int trans) {
        int x = trans % this.w - this.r;
        int y = trans / this.w - this.r;
        if (Math.abs(x) == Math.abs(y)) {
            return -1;
        }
        if (Math.abs(x) > Math.abs(y)) {
            return this.trans(x - MazeGen.sign(x), y);
        }
        return this.trans(x, y - MazeGen.sign(y));
    }

    private void fill(int i, int j) {
        int con = this.conn[i][j];
        int trans = this.inner(i + j * this.w);
        int ai = trans % this.w - i;
        int aj = trans / this.w - j;
        int val = 0;
        if ((con & 2) > 0) {
            if (trans == -1) {
                if (i < this.r && j < this.r) {
                    val |= 2;
                }
                if (i < this.r && j > this.r) {
                    val |= 4;
                }
                if (i > this.r && j < this.r) {
                    val |= 8;
                }
                if (i > this.r && j > this.r) {
                    val |= 1;
                }
            } else {
                val |= this.getMask(aj, -ai);
            }
        }
        if ((con & 1) > 0) {
            if (trans == -1) {
                if (i < this.r && j < this.r) {
                    val |= 8;
                }
                if (i < this.r && j > this.r) {
                    val |= 2;
                }
                if (i > this.r && j < this.r) {
                    val |= 1;
                }
                if (i > this.r && j > this.r) {
                    val |= 4;
                }
            } else {
                val |= this.getMask(-aj, ai);
            }
        }
        if ((con & 4) > 0) {
            val |= this.getMask(ai, aj);
            int[] nArray = this.ans[i + ai];
            int n = j + aj;
            nArray[n] = nArray[n] | this.getMask(-ai, -aj);
        }
        int[] nArray = this.ans[i];
        int n = j;
        nArray[n] = nArray[n] | val;
    }

    private int get(int[][] arr, int code) {
        return arr[code % this.w][code / this.w];
    }

    private <T> T get(T[][] arr, int code) {
        return arr[code % this.w][code / this.w];
    }

    private int getMask(int dx, int dy) {
        if (dx < 0) {
            return 1;
        }
        if (dx > 0) {
            return 2;
        }
        if (dy < 0) {
            return 4;
        }
        if (dy > 0) {
            return 8;
        }
        return 0;
    }

    private PostRim[] getPostRim(int i) {
        ArrayList<PostRim> list = new ArrayList<PostRim>();
        int first = this.rim(i, 0);
        PostRim cur = new PostRim(i, 0, this.get(this.states, first));
        for (int j = 1; j < i * 8; ++j) {
            int code = this.rim(i, j);
            State st = this.get(this.states, code);
            if (cur.state.equals(st)) continue;
            cur.x1 = j - 1;
            list.add(cur);
            cur = new PostRim(i, j, st);
        }
        cur.x1 = i * 8 - 1;
        if (list.size() == 0) {
            list.add(cur);
        } else if (cur.state.equals(((PostRim)list.get((int)0)).state)) {
            ((PostRim)list.get((int)0)).x0 = cur.x0;
        } else {
            list.add(cur);
        }
        return list.toArray(new PostRim[0]);
    }

    private StateRim[] getStateRim(int i) {
        ArrayList<StateRim> list = new ArrayList<StateRim>();
        int first = this.inner(this.rim(i, 1));
        StateRim cur = new StateRim(i, 1, this.get(this.states, first));
        int prev = first;
        for (int j = 2; j <= i * 8; ++j) {
            int code = this.inner(this.rim(i, j));
            if (code == -1) continue;
            State st = this.get(this.states, code);
            int con = this.get(this.conn, code);
            if (prev != code && (con & 1) == 0 || !cur.state.equals(st)) {
                cur.x1 = j - 1;
                list.add(cur);
                cur = new StateRim(i, j, st);
            }
            prev = code;
        }
        if (list.size() == 0) {
            list.add(cur);
        } else if (cur.state.equals(((StateRim)list.get((int)0)).state)) {
            ((StateRim)list.get((int)0)).x0 = cur.x0;
        } else {
            list.add(cur);
        }
        return list.toArray(new StateRim[0]);
    }

    private int rim(int i, int j) {
        int dy;
        int dx;
        if (i == 0) {
            return this.trans(0, 0);
        }
        int step = j % (i * 2);
        int rot = j / (i * 2) % 4;
        if (rot == 0) {
            dx = -i + step;
            dy = -i;
        } else if (rot == 1) {
            dx = i;
            dy = -i + step;
        } else if (rot == 2) {
            dx = i - step;
            dy = i;
        } else {
            dx = -i;
            dy = i - step;
        }
        return this.trans(dx, dy);
    }

    private void set(int[][] arr, int code, int val) {
        arr[code % this.w][code / this.w] = val;
    }

    private <T> void set(T[][] arr, int code, T val) {
        arr[code % this.w][code / this.w] = val;
    }

    private int trans(int x, int y) {
        return x + this.r + (y + this.r) * this.w;
    }

    public static class Debugger {
        MazeGen maze;
        StateRim[] cur_rims;
        StateRim cur_rim;
        int root_count;
        private final boolean skip = true;

        private void begin(MazeGen gen) {
            this.maze = gen;
        }

        private synchronized void breakpoint(String msg) {
        }
    }

    class State {
        private final int ind;
        private State parent;

        private State() {
            this.ind = MazeGen.this.STATE_LIST.size();
            MazeGen.this.STATE_LIST.add(this);
        }

        int getInd() {
            return this.getRoot().ind;
        }

        boolean isRoot() {
            return this.getInd() == 0;
        }

        private boolean equals(State st) {
            return this.getInd() == st.getInd();
        }

        private State getRoot() {
            if (this.parent != null) {
                return this.parent.getRoot();
            }
            return this;
        }

        private void set(State st) {
            this.getRoot().parent = st;
        }
    }

    class StateRim {
        int r;
        int x0;
        int x1;
        State state;
        int path;
        int loop;
        int[] paths;

        private StateRim(int i, int j0, State val) {
            this.r = i;
            this.x0 = j0;
            this.state = val;
        }

        int aviLoop() {
            return this.len() - this.path;
        }

        int aviPath() {
            return this.len() - this.cornerCount();
        }

        private int cornerCount() {
            int a0 = this.x0;
            int a1 = this.x1;
            int ans = 0;
            if (this.x1 < this.x0) {
                this.x1 += this.r * 8;
            }
            for (int i = 0; i < 4; ++i) {
                int c = this.r * 2 * i;
                if (c < this.x0) {
                    c += this.r * 8;
                }
                if (c < a0 || c > a1) continue;
                ++ans;
            }
            return ans;
        }

        private int len() {
            if (this.x1 >= this.x0) {
                return this.x1 - this.x0 + 1;
            }
            return this.x1 + this.r * 8 - this.x0 + 1;
        }

        private void seg() {
            int ind;
            this.paths = new int[this.len()];
            if (this.loop == 0 && this.path == 0) {
                System.out.println("ERROR: all zero");
            }
            int[] rarr = MazeGen.randArray(this.paths.length, MazeGen.this.rand);
            if (this.r - 1 < MazeGen.this.config.INVARIANCE_RIM.length && this.len() == MazeGen.this.config.INVARIANCE_RIM[this.r - 1].length) {
                rarr = MazeGen.this.config.INVARIANCE_RIM[this.r - 1];
            }
            State[] sts = new State[this.loop];
            for (int i = 0; i < this.loop; ++i) {
                sts[i] = new State();
            }
            State[] sta = new State[this.paths.length];
            int i = 0;
            while (this.path > 0) {
                if (((ind = rarr[i++]) + this.x0) % (this.r * 2) == 0) continue;
                this.paths[ind] = 1;
                sta[ind] = this.state;
                --this.path;
            }
            i = 0;
            rarr = MazeGen.randArray(this.paths.length, MazeGen.this.rand);
            while (this.loop > 0) {
                if (this.paths[ind = rarr[i++]] > 0) continue;
                this.paths[ind] = 2;
                sta[ind] = sts[sts.length - this.loop];
                --this.loop;
            }
            rarr = MazeGen.randArray(this.paths.length, MazeGen.this.rand);
            for (i = 0; i < this.paths.length; ++i) {
                ind = rarr[i];
                if (this.paths[ind] != 0) continue;
                int dir = MazeGen.this.rand.nextInt(2);
                int off = dir * 2 - 1;
                while (ind >= 0 && ind < this.paths.length && this.paths[ind] == 0) {
                    this.paths[ind] = dir + 3;
                    ind += off;
                }
            }
            if (this.paths[0] == 3) {
                i = 0;
                while (this.paths[i] == 3) {
                    this.paths[i] = 4;
                    ++i;
                }
            }
            if (this.paths[this.paths.length - 1] == 4) {
                i = this.paths.length - 1;
                while (this.paths[i] == 4) {
                    this.paths[i] = 3;
                    --i;
                }
            }
            for (i = 0; i < this.paths.length; ++i) {
                if (sta[i] == null) continue;
                if (i > 0) {
                    ind = i - 1;
                    while (ind >= 0 && this.paths[ind] == 4) {
                        sta[ind--] = sta[i];
                    }
                }
                if (i >= this.paths.length - 1) continue;
                ind = i + 1;
                while (ind < this.paths.length && this.paths[ind] == 3) {
                    sta[ind++] = sta[i];
                }
            }
            for (i = 0; i < this.paths.length; ++i) {
                int trans = MazeGen.this.rim(this.r, this.x0 + i);
                int val = 0;
                if (this.paths[i] == 3) {
                    val |= 1;
                }
                if (this.paths[i] == 4) {
                    val |= 2;
                }
                if (i > 0 && this.paths[i - 1] == 4) {
                    val |= 1;
                }
                if (i < this.paths.length - 1 && this.paths[i + 1] == 3) {
                    val |= 2;
                }
                if (this.paths[i] == 1) {
                    val |= 4;
                }
                MazeGen.this.set(MazeGen.this.conn, trans, val);
                MazeGen.this.set(MazeGen.this.states, trans, sta[i]);
            }
        }
    }

    private class PostRim {
        private int x0;
        private int x1;
        private final State state;

        private PostRim(int i, int j0, State val) {
            this.x0 = j0;
            this.state = val;
        }
    }
}

