/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.idea.magic;

import dev.xkmc.l2library.idea.magic.ArrowResult;
import dev.xkmc.l2library.idea.magic.FlowChart;
import dev.xkmc.l2library.idea.magic.HexCalcException;
import dev.xkmc.l2library.idea.magic.HexCell;
import dev.xkmc.l2library.idea.magic.HexDirection;
import dev.xkmc.l2library.idea.magic.HexHandler;
import dev.xkmc.l2library.util.math.Frac;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;

class HexCalc {
    private final HexHandler hexHandler;
    final CalcCell[][] ccell;
    final List<CalcCell> list;
    final Set<Arrow> pool = new HashSet<Arrow>();
    Queue<Arrow> head = new ArrayDeque<Arrow>();
    private Arrow[] in;
    private Map<CalcCell, Map<HexDirection, FlowChart.Flow>> flowmap;

    /*
     * WARNING - void declaration
     */
    public HexCalc(HexHandler hexHandler) {
        int n;
        this.hexHandler = hexHandler;
        this.ccell = new CalcCell[hexHandler.cells.length][];
        boolean[][] used = new boolean[hexHandler.cells.length][];
        for (int i = 0; i < this.ccell.length; ++i) {
            this.ccell[i] = new CalcCell[hexHandler.cells[i].length];
            used[i] = new boolean[hexHandler.cells[i].length];
            for (int j = 0; j < this.ccell[i].length; ++j) {
                this.ccell[i][j] = new CalcCell(hexHandler, i, j);
            }
        }
        this.list = new ArrayList<CalcCell>();
        this.list.add(this.ccell[hexHandler.radius][hexHandler.getCellCount(hexHandler.radius) - 1]);
        this.list.add(this.ccell[hexHandler.radius * 2][hexHandler.getCellCount(hexHandler.radius * 2) - 1]);
        this.list.add(this.ccell[hexHandler.radius * 2][0]);
        this.list.add(this.ccell[hexHandler.radius][0]);
        this.list.add(this.ccell[0][0]);
        this.list.add(this.ccell[0][hexHandler.getCellCount(0) - 1]);
        for (CalcCell cc2 : this.list) {
            cc2.origin = true;
        }
        ArrayDeque<CalcCell> queue = new ArrayDeque<CalcCell>();
        for (CalcCell calcCell : this.list) {
            if (!calcCell.exists()) continue;
            used[calcCell.row][calcCell.cell] = true;
            queue.add(calcCell);
        }
        while (queue.size() > 0) {
            CalcCell cc = (CalcCell)queue.poll();
            HexDirection[] n2 = HexDirection.values();
            n = n2.length;
            for (int i = 0; i < n; ++i) {
                HexDirection dir = n2[i];
                CalcCell cx = cc.neighbor(dir);
                if (cx == null || used[cx.row][cx.cell]) continue;
                used[cx.row][cx.cell] = true;
                queue.add(cx);
            }
        }
        for (int i = 0; i < used.length; ++i) {
            void var5_15;
            boolean bl = false;
            while (var5_15 < used[i].length) {
                if (!used[i][var5_15]) {
                    this.ccell[i][var5_15] = null;
                }
                ++var5_15;
            }
        }
        CalcCell[][] calcCellArray = this.ccell;
        int n2 = calcCellArray.length;
        for (n = 0; n < n2; ++n) {
            CalcCell[] calcCells;
            for (CalcCell calcCell : calcCells = calcCellArray[n]) {
                if (calcCell == null) continue;
                calcCell.init();
            }
        }
        for (CalcCell[] calcCells : this.ccell) {
            for (CalcCell calcCell : calcCells) {
                if (calcCell == null || calcCell.count > 2) continue;
                calcCell.remove();
            }
        }
        for (CalcCell[] calcCells : this.ccell) {
            for (CalcCell calcCell : calcCells) {
                if (calcCell == null || calcCell.count <= 2) continue;
                calcCell.remove();
            }
        }
    }

    public FlowChart getMatrix(boolean withFlow) {
        int i;
        Frac[][] matrix = new Frac[6][6];
        this.in = new Arrow[6];
        Arrow[] out = new Arrow[6];
        for (i = 0; i < 6; ++i) {
            if (!this.list.get(i).exists()) continue;
            for (Arrow v : this.list.get((int)i).output) {
                if (v == null) continue;
                this.in[i] = v;
            }
            for (Arrow v : this.list.get((int)i).input) {
                if (v == null) continue;
                out[i] = v;
            }
        }
        for (i = 0; i < 6; ++i) {
            if (out[i] == null) continue;
            for (int j = 0; j < 6; ++j) {
                if (this.in[j] == null) continue;
                matrix[j][i] = out[i].map.get(this.in[j]);
            }
        }
        FlowChart ans = new FlowChart(matrix);
        if (!withFlow) {
            return ans;
        }
        this.head.clear();
        HashSet<Arrow> origins = new HashSet<Arrow>();
        for (Arrow v : this.pool) {
            v.user.clear();
            v.rely = 0;
            if (!v.src.origin) continue;
            origins.add(v);
        }
        for (Arrow v : this.pool) {
            for (Arrow dep : v.map.keySet()) {
                if (dep.src.origin) continue;
                dep.user.add(v);
                ++v.rely;
            }
        }
        for (Arrow v : this.pool) {
            if (v.src.origin || v.dst.origin || v.rely != 0) continue;
            this.head.add(v);
        }
        this.flowmap = new HashMap<CalcCell, Map<HexDirection, FlowChart.Flow>>();
        while (this.head.size() > 0) {
            Arrow next = this.head.poll();
            next.remove();
            this.addFlow(ans, next);
        }
        for (int i2 = 0; i2 < 6; ++i2) {
            this.addFlow(ans, this.in[i2]);
            this.addFlow(ans, out[i2]);
        }
        HexCalcException.trycatch(ans);
        return ans;
    }

    private void addFlow(FlowChart ans, Arrow next) {
        Map<HexDirection, FlowChart.Flow> sub;
        if (next == null) {
            return;
        }
        Frac[] formula = new Frac[6];
        for (int i = 0; i < 6; ++i) {
            if (this.in[i] == null) continue;
            formula[i] = this.in[i] == next ? new Frac(1L, 1L) : next.map.get(this.in[i]);
        }
        CalcCell src = next.src;
        HexDirection dir = next.dir;
        if (dir.ind >= 3) {
            src = next.dst;
            dir = dir.next(3);
        }
        if (this.flowmap.containsKey(src)) {
            sub = this.flowmap.get(src);
        } else {
            sub = new HashMap<HexDirection, FlowChart.Flow>();
            this.flowmap.put(src, sub);
        }
        if (sub.containsKey((Object)dir)) {
            flow = sub.get((Object)dir);
        } else {
            FlowChart flowChart = ans;
            Objects.requireNonNull(flowChart);
            flow = new FlowChart.Flow(flowChart, new ArrowResult(src.row, src.cell, dir, this.hexHandler));
            sub.put(dir, flow);
        }
        if (src == next.src) {
            flow.forward = formula;
        } else {
            flow.backward = formula;
        }
    }

    class CalcCell
    extends HexCell {
        int count;
        boolean origin;
        Arrow[] input;
        Arrow[] output;

        CalcCell(HexHandler hex, int row, int cell) {
            super(hex, row, cell);
            this.output = new Arrow[6];
            for (int i = 0; i < 6; ++i) {
                HexDirection dir = HexDirection.values()[i];
                if (!this.isConnected(dir)) continue;
                this.output[i] = new Arrow(this, dir);
                ++this.count;
            }
        }

        public String toString() {
            return (this.origin ? "origin " : "") + "(r = " + this.row + ", c = " + this.cell + ")";
        }

        void init() {
            for (Arrow a : this.output) {
                if (a == null) continue;
                HexCalc.this.pool.add(a);
            }
            this.input = new Arrow[6];
            Frac[][] vars = this.matrix();
            for (int i = 0; i < 6; ++i) {
                HexDirection dir = HexDirection.values()[i];
                if (vars[i] == null) continue;
                this.input[i] = this.neighbor((HexDirection)dir).output[dir.next((int)3).ind];
                this.input[i].dst = this;
                if (this.origin) continue;
                for (int j = 0; j < 6; ++j) {
                    if (vars[i][j] == null) continue;
                    this.output[j].put(this.input[i], vars[i][j]);
                }
            }
        }

        CalcCell neighbor(HexDirection dir) {
            if (!this.canWalk(dir)) {
                return null;
            }
            int nr = dir.getRowOffset();
            int nc = dir.getCellOffset(HexCalc.this.hexHandler.radius, this.row, this.cell);
            return HexCalc.this.ccell[this.row + nr][this.cell + nc];
        }

        void remove() {
            if (this.origin) {
                return;
            }
            for (Arrow v : this.output) {
                if (v == null || v.dst.origin) continue;
                v.remove();
            }
        }
    }

    class Arrow {
        final Map<Arrow, Frac> map = new HashMap<Arrow, Frac>();
        final Set<Arrow> user = new HashSet<Arrow>();
        CalcCell src;
        CalcCell dst;
        HexDirection dir;
        int rely = 0;

        Arrow(CalcCell src, HexDirection dir) {
            this.src = src;
            this.dir = dir;
        }

        public String toString() {
            return "from " + this.src + " to " + this.dst;
        }

        void clear() {
            Frac frac = this.map.remove(this);
            this.user.remove(this);
            if (frac == null) {
                return;
            }
            Frac base = frac.revert();
            for (Frac f : this.map.values()) {
                f.times(base);
            }
        }

        void put(Arrow var, Frac frac) {
            if (this.map.containsKey(var)) {
                frac.add(this.map.get(var));
            }
            this.map.put(var, frac);
            var.user.add(this);
        }

        void remove() {
            this.clear();
            for (Arrow v : this.user) {
                Frac base = v.map.remove(this);
                for (Map.Entry<Arrow, Frac> ent : this.map.entrySet()) {
                    v.put(ent.getKey(), Frac.mult(base, ent.getValue()));
                }
                --v.rely;
                if (v.rely != 0) continue;
                HexCalc.this.head.add(v);
            }
            for (Arrow v : this.map.keySet()) {
                v.user.remove(this);
            }
        }
    }
}

