/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.idea.infmaze.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.xkmc.l2library.base.worldgen.EmptyChunkGenerator;
import dev.xkmc.l2library.idea.infmaze.init.GenerationConfig;
import dev.xkmc.l2library.idea.infmaze.init.InfiniMaze;
import dev.xkmc.l2library.idea.infmaze.init.LeafManager;
import dev.xkmc.l2library.idea.infmaze.worldgen.ChunkFiller;
import dev.xkmc.l2library.idea.infmaze.worldgen.FrameConfig;
import dev.xkmc.l2library.idea.infmaze.worldgen.leaf.RoomLeafManager;
import dev.xkmc.l2library.util.code.LazyFunction;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.StructureSet;

public class MazeChunkGenerator
extends EmptyChunkGenerator {
    private static final int CELL_WIDTH = 8;
    private static final int SCALE = 5;
    private static final int HEIGHT = 256;
    private static final ResourceLocation RL = new ResourceLocation("l2library", "maze_chunkgen");
    private static final LeafManager MANAGER = new RoomLeafManager();
    private static final FrameConfig BLOCKS = new FrameConfig(Blocks.f_50016_.m_49966_(), Blocks.f_50752_.m_49966_(), Blocks.f_50080_.m_49966_(), Blocks.f_50069_.m_49966_());
    public static final Codec<MazeChunkGenerator> CODEC = RecordCodecBuilder.create(e -> MazeChunkGenerator.m_208005_((RecordCodecBuilder.Instance)e).and((App)RegistryOps.m_206832_((ResourceKey)Registry.f_122885_).forGetter(x -> x.biomes)).apply((Applicative)e, e.stable(MazeChunkGenerator::new)));
    private final Registry<Biome> biomes;
    private final LazyFunction<Long, InfiniMaze> maze;
    private final ChunkFiller filler;

    public MazeChunkGenerator(Registry<StructureSet> structures, Registry<Biome> biomes) {
        super(structures, Optional.empty(), (BiomeSource)new FixedBiomeSource((Holder)biomes.m_203636_(Biomes.f_48202_).get()));
        this.biomes = biomes;
        this.maze = LazyFunction.create(seed -> new InfiniMaze(new GenerationConfig(5, (long)seed, MANAGER)));
        this.filler = new ChunkFiller(8, 5, BLOCKS);
    }

    public int m_6331_() {
        return 256;
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    public CompletableFuture<ChunkAccess> m_213974_(Executor executor, Blender blender, RandomState random, StructureManager structures, ChunkAccess access) {
        return CompletableFuture.supplyAsync(() -> {
            InfiniMaze maze = this.maze.get(random.m_224559_());
            ChunkPos pos = access.m_7697_();
            this.filler.fillChunk(maze, pos, access, random);
            return access;
        }, executor);
    }

    public int m_214096_(int x, int z, Heightmap.Types type, LevelHeightAccessor height, RandomState random) {
        return this.m_6331_();
    }

    public NoiseColumn m_214184_(int x, int z, LevelHeightAccessor height, RandomState random) {
        BlockState[] states = new BlockState[height.m_141928_()];
        for (int i = 0; i < height.m_141928_(); ++i) {
            states[i] = BLOCKS.wall();
        }
        return new NoiseColumn(height.m_141937_(), states);
    }
}

