/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.idea.infmaze.pos;

import dev.xkmc.l2library.idea.infmaze.pos.MazeDirection;
import org.jetbrains.annotations.NotNull;

public interface IBasePos
extends Comparable<IBasePos> {
    public long x();

    public long y();

    public long z();

    public IBasePos offset(MazeDirection var1, long var2);

    public IBasePos offset(long var1, long var3, long var5);

    @Override
    default public int compareTo(@NotNull IBasePos o) {
        int dx = Long.compare(this.x(), o.x());
        if (dx != 0) {
            return dx;
        }
        int dy = Long.compare(this.y(), o.y());
        if (dy != 0) {
            return dy;
        }
        return Long.compare(this.z(), o.z());
    }

    default public long l1dist(IBasePos pos) {
        return Math.abs(pos.x() - this.x()) + Math.abs(pos.y() - this.y()) + Math.abs(pos.z() - this.z());
    }
}

