/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.idea.infmaze.dim3d;

import dev.xkmc.l2library.idea.infmaze.dim3d.GenerationHelper;
import dev.xkmc.l2library.idea.infmaze.dim3d.MazeWall3D;
import dev.xkmc.l2library.idea.infmaze.init.CellContent;
import dev.xkmc.l2library.idea.infmaze.pos.CellPos;
import dev.xkmc.l2library.idea.infmaze.pos.MazeAxis;
import dev.xkmc.l2library.idea.infmaze.pos.MazeDirection;
import dev.xkmc.l2library.idea.infmaze.pos.WallPos;

public class MazeCell3D {
    public final CellPos pos;
    public final CellContent content;
    private final long seed;
    private final GenerationHelper helper;
    private final MazeWall3D[] walls;
    private Internal internal;

    public MazeCell3D(GenerationHelper helper, CellPos pos, long seed, MazeWall3D[] walls) {
        this.helper = helper;
        this.pos = pos;
        this.seed = seed;
        this.walls = walls;
        ++helper.cellCount;
        int openWall = 0;
        for (MazeWall3D wall : walls) {
            if (!wall.open) continue;
            ++openWall;
        }
        this.content = openWall != 1 ? null : helper.getLeaf(this, seed);
    }

    public MazeCell3D loadChild(int index) {
        if (this.content != null) {
            return this;
        }
        if (this.internal == null) {
            this.internal = new Internal(this);
        }
        return this.internal.children[index];
    }

    public boolean isLeaf() {
        return this.content != null;
    }

    public MazeWall3D getWall(MazeDirection dire) {
        return this.walls[dire.ordinal()];
    }

    private static class Internal {
        private static final int[][] locator = new int[8][6];
        private final MazeCell3D[] children;

        private static void locate(MazeWall3D[] outer, MazeWall3D[] inner, MazeWall3D[][] result) {
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 6; ++j) {
                    int loc = locator[i][j];
                    result[i][j] = loc < 24 ? outer[loc >> 2].loadChild(loc & 3) : inner[loc - 24];
                }
            }
        }

        private Internal(MazeCell3D holder) {
            long[] seeds = new long[22];
            holder.helper.getChildrenSeeds(holder.seed, seeds);
            int wallState = holder.helper.randomizeCellInternalState(seeds[20]);
            MazeWall3D[] walls = new MazeWall3D[12];
            int scale = holder.pos.scale() - 1;
            for (int i = 0; i < 3; ++i) {
                MazeAxis axis = MazeAxis.values()[i];
                WallPos raw = holder.pos.getWallPos(MazeDirection.getDirection(axis, -1)).offset((long)axis.x << scale, (long)axis.y << scale, (long)axis.z << scale, 0);
                for (int j = 0; j < 4; ++j) {
                    int du = (j & 1) << scale;
                    int dv = (j >> 1 & 1) << scale;
                    WallPos pos = raw.offset(du, dv, -1);
                    int index = i << 2 | j;
                    boolean state = (wallState >> index & 1) == 1;
                    walls[index] = new MazeWall3D(holder.helper, pos, state, seeds[index]);
                }
            }
            this.children = new MazeCell3D[8];
            MazeWall3D[][] subWalls = new MazeWall3D[8][6];
            Internal.locate(holder.walls, walls, subWalls);
            for (int i = 0; i < 8; ++i) {
                int dx = (i & 1) << scale;
                int dy = (i >> 1 & 1) << scale;
                int dz = (i >> 2 & 1) << scale;
                CellPos subPos = new CellPos(holder.pos.pos().offset(dx, dy, dz), holder.pos.scale() - 1);
                this.children[i] = new MazeCell3D(holder.helper, subPos, seeds[i + 12], subWalls[i]);
            }
        }

        static {
            for (int i = 0; i < 8; ++i) {
                int dx = i & 1;
                int dy = i >> 1 & 1;
                int dz = i >> 2 & 1;
                for (int j = 0; j < 6; ++j) {
                    int faceIndex;
                    MazeDirection dire = MazeDirection.values()[j];
                    int offset = (i >> dire.axis.ordinal() & 1) + (dire.factor + 1 >> 1);
                    int min = MazeDirection.getDirection(dire.axis, -1).ordinal();
                    int max = MazeDirection.getDirection(dire.axis, 1).ordinal();
                    switch (dire.axis) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case X: {
                            int n = dy | dz << 1;
                            break;
                        }
                        case Y: {
                            int n = dx | dz << 1;
                            break;
                        }
                        case Z: {
                            int n = faceIndex = dx | dy << 1;
                        }
                    }
                    Internal.locator[i][j] = offset == 0 ? min << 2 | faceIndex : (offset == 2 ? max << 2 | faceIndex : 24 + (dire.axis.ordinal() << 2) + faceIndex);
                }
            }
        }
    }
}

