/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.compat.curio;

import dev.xkmc.l2library.compat.curio.BaseCuriosWrapper;
import dev.xkmc.l2library.compat.curio.CuriosSlotWrapper;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class CuriosWrapper
extends BaseCuriosWrapper {
    private final ArrayList<CuriosSlotWrapper> list = new ArrayList();

    public CuriosWrapper(LivingEntity player, int page) {
        super(player);
        int max = 6;
        Optional opt = player.getCapability(CuriosCapability.INVENTORY).resolve();
        this.page = page;
        if (opt.isEmpty()) {
            this.total = 0;
            return;
        }
        ICuriosItemHandler cap = (ICuriosItemHandler)opt.get();
        int offset = page * max * 9;
        int count = 0;
        for (Map.Entry ent : cap.getCurios().entrySet()) {
            ICurioStacksHandler stack = (ICurioStacksHandler)ent.getValue();
            if (!stack.isVisible()) continue;
            for (int i = 0; i < stack.getSlots(); ++i) {
                ++count;
                if (offset > 0) {
                    --offset;
                    continue;
                }
                if (this.list.size() >= max * 9) continue;
                this.list.add(new CuriosSlotWrapper(player, stack, i, (String)ent.getKey()));
            }
        }
        this.total = (count - 1) / (max * 9) + 1;
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    @Override
    public int getRows() {
        return this.list.isEmpty() ? 0 : (this.list.size() - 1) / 9 + 1;
    }

    @Override
    @Nullable
    public CuriosSlotWrapper getSlotAtPosition(int i) {
        if (i < 0 || i >= this.list.size()) {
            return null;
        }
        return this.list.get(i);
    }
}

