/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.capability.player;

import dev.xkmc.l2library.capability.player.PlayerCapabilityHolder;
import dev.xkmc.l2library.capability.player.PlayerCapabilityTemplate;
import dev.xkmc.l2library.serial.SerialClass;
import dev.xkmc.l2library.serial.codec.TagCodec;
import dev.xkmc.l2library.util.code.Wrappers;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.logging.log4j.LogManager;

@SerialClass
public class PlayerCapabilitySerializer<C extends PlayerCapabilityTemplate<C>>
implements ICapabilitySerializable<CompoundTag> {
    public final Player player;
    public final Level level;
    public final PlayerCapabilityHolder<C> holder;
    public C handler;
    public LazyOptional<C> lo = LazyOptional.of(() -> this.handler);

    public PlayerCapabilitySerializer(Player player, Level w, PlayerCapabilityHolder<C> holder) {
        this.player = player;
        this.level = w;
        this.holder = holder;
        if (w == null) {
            LogManager.getLogger().error("level not present in entity");
        }
        this.handler = (PlayerCapabilityTemplate)holder.sup.get();
        ((PlayerCapabilityTemplate)this.handler).world = w;
        ((PlayerCapabilityTemplate)this.handler).player = player;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction direction) {
        if (capability == this.holder.capability) {
            return this.lo.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return TagCodec.toTag(new CompoundTag(), this.lo.resolve().get());
    }

    public void deserializeNBT(CompoundTag tag) {
        Wrappers.get(() -> (PlayerCapabilityTemplate)TagCodec.fromTag(tag, this.holder.cls, this.handler, f -> true));
    }
}

