/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.base.overlay;

import net.minecraft.client.Minecraft;

public abstract class SideBar {
    protected final float max_time;
    protected final float max_ease;
    protected int prev = 0;
    protected float idle = 0.0f;
    protected float ease_time = 0.0f;
    protected float prev_time = -1.0f;

    public SideBar(float duration, float ease) {
        this.max_time = duration;
        this.max_ease = ease;
    }

    public abstract int getSignature();

    public abstract boolean isScreenOn();

    protected boolean isOnHold() {
        return Minecraft.m_91087_().f_91066_.f_92090_.m_90857_();
    }

    protected boolean ease(float current_time) {
        if (!this.isScreenOn()) {
            this.prev = 0;
            this.idle = 0.0f;
            this.ease_time = 0.0f;
            this.prev_time = -1.0f;
            return false;
        }
        float time_diff = this.prev_time < 0.0f ? 0.0f : current_time - this.prev_time;
        this.prev_time = current_time;
        int signature = this.getSignature();
        if (signature != this.prev || this.isOnHold()) {
            this.prev = signature;
            this.idle = 0.0f;
        } else {
            this.idle += time_diff;
        }
        if (this.idle < this.max_time) {
            if (this.ease_time < this.max_ease) {
                this.ease_time += time_diff;
                if (this.ease_time > this.max_ease) {
                    this.ease_time = this.max_ease;
                }
            }
        } else if (this.ease_time > 0.0f) {
            this.ease_time -= time_diff;
            if (this.ease_time < 0.0f) {
                this.ease_time = 0.0f;
            }
        }
        return this.ease_time > 0.0f;
    }

    protected int getXOffset(int width) {
        return 0;
    }

    protected int getYOffset(int height) {
        return 0;
    }
}

