/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.base.overlay;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.xkmc.l2library.serial.SerialClass;
import dev.xkmc.l2library.serial.codec.JsonCodec;
import dev.xkmc.l2library.util.code.Wrappers;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;

@SerialClass
public class OverlayManager {
    public static final Map<ResourceLocation, OverlayManager> MAP = new HashMap<ResourceLocation, OverlayManager>();
    private final String name;
    private final ResourceLocation coords;
    private final ResourceLocation texture;
    @SerialClass.SerialField
    public HashMap<String, Rect> elements;
    public boolean loaded = false;

    public static OverlayManager get(String modid, String path) {
        OverlayManager old = MAP.get(new ResourceLocation(modid, path));
        if (old != null) {
            return old;
        }
        return new OverlayManager(modid, path);
    }

    private OverlayManager(String mod, String str) {
        this.name = mod + ":" + str;
        this.coords = new ResourceLocation(mod, str);
        this.texture = new ResourceLocation(mod, "textures/gui/widgets/" + str + ".png");
        this.check();
        MAP.put(new ResourceLocation(mod, str), this);
    }

    public void reset(JsonElement elem) {
        JsonCodec.from((JsonElement)elem.getAsJsonObject(), OverlayManager.class, this);
        this.loaded = true;
    }

    public Rect getComp(String key) {
        this.check();
        return this.elements.getOrDefault(key, Rect.ZERO);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ScreenRenderer getRenderer(ForgeGui gui, PoseStack stack) {
        this.check();
        return new ScreenRenderer(gui, stack);
    }

    public String toString() {
        return this.name;
    }

    private void check() {
        if (!this.loaded) {
            this.load();
        }
    }

    private void load() {
        JsonObject jo = Wrappers.get(() -> GsonHelper.m_13859_((Reader)new InputStreamReader(((Resource)Minecraft.m_91087_().m_91098_().m_213713_(new ResourceLocation(this.coords.m_135827_(), "textures/gui/overlays/" + this.coords.m_135815_() + ".json")).get()).m_215507_(), StandardCharsets.UTF_8)));
        JsonCodec.from((JsonElement)jo, OverlayManager.class, this);
        this.loaded = true;
    }

    @SerialClass
    public static class Rect {
        public static final Rect ZERO = new Rect();
        @SerialClass.SerialField
        public int sx;
        @SerialClass.SerialField
        public int sy;
        @SerialClass.SerialField
        public int tx;
        @SerialClass.SerialField
        public int ty;
        @SerialClass.SerialField
        public int w;
        @SerialClass.SerialField
        public int h;
    }

    @OnlyIn(value=Dist.CLIENT)
    public class ScreenRenderer {
        private final int x;
        private final int y;
        public final ForgeGui gui;
        public final PoseStack stack;
        public final Entity cameraEntity;
        public final LocalPlayer localPlayer;

        public ScreenRenderer(ForgeGui gui, PoseStack stack) {
            this.gui = gui;
            this.stack = stack;
            this.x = gui.f_92977_ / 2;
            this.y = gui.f_92978_;
            this.localPlayer = gui.f_92986_.f_91074_;
            this.cameraEntity = gui.f_92986_.m_91288_();
        }

        public void start() {
            this.gui.setupOverlayRenderState(true, false, OverlayManager.this.texture);
        }

        public Rect get(String str) {
            return OverlayManager.this.getComp(str);
        }

        public void draw(String c) {
            Rect cr = OverlayManager.this.getComp(c);
            this.gui.m_93228_(this.stack, this.x + cr.sx, this.y + cr.sy, cr.tx, cr.ty, cr.w, cr.h);
        }

        public void draw(String c, int dx, int dy) {
            Rect cr = OverlayManager.this.getComp(c);
            this.gui.m_93228_(this.stack, this.x + cr.sx + dx, this.y + cr.sy + dy, cr.tx, cr.ty, cr.w, cr.h);
        }

        public void blit(String c, int sx, int sy, int tx, int ty, int dw, int dh) {
            Rect cr = OverlayManager.this.getComp(c);
            this.gui.m_93228_(this.stack, this.x + cr.sx + sx, this.y + cr.sy + sy, cr.tx + tx, cr.ty + ty, cr.w + dw, cr.h + dh);
        }

        public void drawBottomUp(String c, int prog, int max) {
            if (prog == 0 || max == 0) {
                return;
            }
            Rect cr = OverlayManager.this.getComp(c);
            int dh = cr.h * prog / max;
            this.gui.m_93228_(this.stack, this.x + cr.sx, this.y + cr.sy + cr.h - dh, cr.tx, cr.ty + cr.h - dh, cr.w, dh);
        }

        public void drawLeftRight(String c, double prog, double max) {
            if (prog == 0.0 || max == 0.0) {
                return;
            }
            Rect cr = OverlayManager.this.getComp(c);
            prog = Math.min(prog, max);
            int dw = (int)Math.floor((double)cr.w * prog / max);
            this.gui.m_93228_(this.stack, this.x + cr.sx, this.y + cr.sy, cr.tx, cr.ty, dw, cr.h);
        }

        public void drawRightLeft(String c, double prog, double max) {
            if (prog == 0.0 || max == 0.0) {
                return;
            }
            Rect cr = OverlayManager.this.getComp(c);
            prog = Math.min(prog, max);
            int dw = (int)Math.floor((double)cr.w * prog / max);
            this.gui.m_93228_(this.stack, this.x + cr.sx + cr.w - dw, this.y + cr.sy, cr.tx + cr.w - dw, cr.ty, dw, cr.h);
        }
    }
}

