/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.base.menu.stacked;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.xkmc.l2library.base.menu.SpriteManager;
import dev.xkmc.l2library.base.menu.stacked.CellEntry;
import dev.xkmc.l2library.base.menu.stacked.TextButtonHandle;
import dev.xkmc.l2library.base.menu.stacked.TextEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class StackedRenderHandle {
    static final int BTN_X_OFFSET = 3;
    static final int TEXT_BASE_HEIGHT = 8;
    private static final int SLOT_X_OFFSET = 7;
    private static final int SLOT_SIZE = 18;
    private static final int SPRITE_OFFSET = 176;
    final Screen scr;
    final PoseStack stack;
    final SpriteManager sm;
    final Font font;
    final int text_color;
    private final int TEXT_Y_OFFSET;
    private final int TEXT_HEIGHT;
    private final int text_x_offset;
    private int current_y = 3;
    private int current_x = 0;
    final List<TextEntry> textList = new ArrayList<TextEntry>();

    public StackedRenderHandle(Screen scr, PoseStack stack, SpriteManager sm) {
        this(scr, stack, sm, 3);
    }

    public StackedRenderHandle(Screen scr, PoseStack stack, SpriteManager sm, int ty) {
        this(scr, stack, 8, 0x404040, sm, ty);
    }

    public StackedRenderHandle(Screen scr, PoseStack stack, int x_offset, int color, SpriteManager sm) {
        this(scr, stack, x_offset, color, sm, 3);
    }

    public StackedRenderHandle(Screen scr, PoseStack stack, int x_offset, int color, SpriteManager sm, int ty) {
        this.font = Minecraft.m_91087_().f_91062_;
        this.stack = stack;
        this.scr = scr;
        this.sm = sm;
        this.text_color = color;
        this.text_x_offset = x_offset;
        this.TEXT_Y_OFFSET = ty;
        Objects.requireNonNull(this.font);
        this.TEXT_HEIGHT = 9 + ty + 1;
    }

    public void drawText(Component text) {
        this.endCell();
        int y = this.current_y + this.TEXT_Y_OFFSET;
        this.textList.add(new TextEntry(this.stack, text, this.text_x_offset, y, this.text_color));
        this.current_y += this.TEXT_HEIGHT;
    }

    public void drawTable(Component[][] table, int x_max) {
        this.endCell();
        int w = table[0].length;
        int w1 = 0;
        int ws = 0;
        for (Component[] c : table) {
            w1 = Math.max(w1, this.font.m_92852_((FormattedText)c[0]));
            for (int i = 1; i < w; ++i) {
                ws = Math.max(ws, this.font.m_92852_((FormattedText)c[i]));
            }
        }
        int sumw = w1 + ws * (w - 1);
        int x0 = this.text_x_offset;
        int x1 = x_max - this.text_x_offset;
        float space = (float)(x1 - x0 - sumw) * 1.0f / (float)(w - 1);
        for (Component[] c : table) {
            int y = this.current_y + this.TEXT_Y_OFFSET;
            float x_start = x0;
            for (int i = 0; i < w; ++i) {
                float wi = i == 0 ? (float)w1 : (float)ws;
                int x = Math.round(x_start);
                this.textList.add(new TextEntry(this.stack, c[i], x, y, this.text_color));
                x_start += wi + space;
            }
            this.current_y += this.TEXT_HEIGHT;
        }
    }

    public TextButtonHandle drawTextWithButtons(Component text) {
        this.endCell();
        int y = this.current_y + this.TEXT_Y_OFFSET;
        this.textList.add(new TextEntry(this.stack, text, this.text_x_offset, y, this.text_color));
        int x_off = this.text_x_offset + this.font.m_92852_((FormattedText)text) + 3;
        Objects.requireNonNull(this.font);
        TextButtonHandle ans = new TextButtonHandle(this, x_off, y + 9 / 2);
        this.current_y += this.TEXT_HEIGHT;
        return ans;
    }

    public CellEntry addCell(boolean toggled, boolean disabled) {
        this.startCell();
        int index = toggled ? 1 : (disabled ? 2 : 0);
        int x = 7 + this.current_x * 18;
        int u = 176 + index * 18;
        this.scr.m_93228_(this.stack, x, this.current_y, u, 0, 18, 18);
        CellEntry ans = new CellEntry(x + 1, this.current_y + 1, 16, 16);
        ++this.current_x;
        if (this.current_x == 9) {
            this.endCell();
        }
        return ans;
    }

    private void startCell() {
        if (this.current_x < 0) {
            this.current_x = 0;
        }
    }

    private void endCell() {
        if (this.current_x > 0) {
            this.current_x = -1;
            this.current_y += 18;
        }
    }

    public void flushText() {
        this.textList.forEach(e -> this.font.m_92889_(e.stack(), e.text(), (float)e.x(), (float)e.y(), e.color()));
    }
}

