/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2library.base.advancements;

import dev.xkmc.l2library.base.advancements.CriterionBuilder;
import dev.xkmc.l2library.repack.registrate.providers.RegistrateAdvancementProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.FrameType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AdvancementGenerator {
    private final RegistrateAdvancementProvider pvd;
    private final String modid;

    public AdvancementGenerator(RegistrateAdvancementProvider pvd, String modid) {
        this.pvd = pvd;
        this.modid = modid;
    }

    private record EntryData(String id, ItemStack item, CriterionBuilder builder, String title, String desc) {
    }

    public class TabBuilder {
        private final String tab;
        private final ResourceLocation bg;
        private Entry root;

        public TabBuilder(String tab) {
            this.tab = tab;
            this.bg = new ResourceLocation(AdvancementGenerator.this.modid, "textures/gui/advancements/backgrounds/" + tab + ".png");
        }

        public void build() {
            this.root.build();
        }

        public Entry root(String id, Item item, CriterionBuilder builder, String title, String desc) {
            return this.root(id, item.m_7968_(), builder, title, desc);
        }

        public Entry root(String id, ItemStack item, CriterionBuilder builder, String title, String desc) {
            if (this.root == null) {
                this.root = new Entry(new EntryData(id, item, builder, title, desc), null);
            }
            return this.root;
        }

        public class Entry {
            private final List<Entry> children = new ArrayList<Entry>();
            private final EntryData data;
            private final ResourceLocation rl;
            private final Entry parent;
            private FrameType type = FrameType.TASK;
            private boolean showToast = true;
            private boolean announce = true;
            private boolean hidden = false;
            private Advancement result;

            private Entry(@Nullable EntryData data, Entry parent) {
                this.data = data;
                this.parent = parent;
                if (parent == null) {
                    this.showToast = false;
                    this.announce = false;
                    this.rl = TabBuilder.this.bg;
                } else {
                    this.rl = null;
                }
            }

            public Entry create(String id, Item item, CriterionBuilder builder, String title, String desc) {
                return this.create(id, item.m_7968_(), builder, title, desc);
            }

            public Entry create(String id, ItemStack item, CriterionBuilder builder, String title, String desc) {
                Entry sub = new Entry(new EntryData(id, item, builder, title, desc), this);
                this.children.add(sub);
                return sub;
            }

            public Entry root() {
                return TabBuilder.this.root;
            }

            public Entry enter() {
                return this.children.get(this.children.size() - 1);
            }

            public Entry type(FrameType type) {
                this.type = type;
                return this;
            }

            public Entry type(FrameType type, boolean showToast, boolean announce, boolean hidden) {
                this.type = type;
                this.showToast = showToast;
                this.announce = announce;
                this.hidden = hidden;
                return this;
            }

            private void build() {
                Advancement.Builder builder = Advancement.Builder.m_138353_().m_138362_(this.data.item, (Component)AdvancementGenerator.this.pvd.title(AdvancementGenerator.this.modid, "advancements." + TabBuilder.this.tab + "." + this.data.id, this.data.title), (Component)AdvancementGenerator.this.pvd.desc(AdvancementGenerator.this.modid, "advancements." + TabBuilder.this.tab + "." + this.data.id, this.data.desc), this.rl, this.type, this.showToast, this.announce, this.hidden);
                if (this.parent != null) {
                    builder.m_138398_(this.parent.result);
                }
                String uid = AdvancementGenerator.this.modid + ":" + TabBuilder.this.tab + "/" + this.data.id;
                this.data.builder.accept(uid, builder);
                this.result = builder.m_138389_((Consumer)AdvancementGenerator.this.pvd, uid);
                for (Entry e : this.children) {
                    e.build();
                }
            }

            public void finish() {
                TabBuilder.this.build();
            }
        }
    }
}

