/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.network.drawer;

import dev.xkmc.l2backpack.content.drawer.BaseDrawerItem;
import dev.xkmc.l2backpack.content.remote.drawer.EnderDrawerItem;
import dev.xkmc.l2backpack.init.L2Backpack;
import dev.xkmc.l2backpack.init.advancement.BackpackTriggers;
import dev.xkmc.l2backpack.network.drawer.CreativeSetCarryToClient;
import dev.xkmc.l2library.serial.SerialClass;
import dev.xkmc.l2library.serial.network.SerialPacketBase;
import dev.xkmc.l2library.serial.network.SimplePacketBase;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;

@SerialClass
public class DrawerInteractToServer
extends SerialPacketBase {
    @SerialClass.SerialField
    public Type type;
    @SerialClass.SerialField
    public int wid;
    @SerialClass.SerialField
    public int slot;
    @SerialClass.SerialField
    public Item item;
    @SerialClass.SerialField
    public int count;

    @Deprecated
    public DrawerInteractToServer() {
    }

    public DrawerInteractToServer(Type type, int wid, int slot, ItemStack carried) {
        this.type = type;
        this.wid = wid;
        this.slot = slot;
        this.item = carried.m_41720_();
        this.count = carried.m_41613_();
    }

    public void handle(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player == null) {
            return;
        }
        AbstractContainerMenu menu = player.f_36096_;
        if (menu.f_38840_ != this.wid) {
            return;
        }
        if (this.wid != 0 && !menu.m_38853_(this.slot).m_150651_((Player)player)) {
            return;
        }
        ItemStack drawer = this.wid == 0 ? player.m_150109_().m_8020_(this.slot) : menu.m_38853_(this.slot).m_7993_();
        Item item = drawer.m_41720_();
        if (!(item instanceof BaseDrawerItem)) {
            return;
        }
        BaseDrawerItem drawerItem = (BaseDrawerItem)item;
        if (drawerItem instanceof EnderDrawerItem && EnderDrawerItem.getOwner(drawer).map(e -> !e.equals(player.m_20148_())).orElse(false).booleanValue()) {
            BackpackTriggers.SHARE.trigger(player);
        }
        ItemStack carried = menu.m_142621_();
        if (player.m_7500_() && this.wid == 0) {
            carried = new ItemStack((ItemLike)this.item, this.count);
        }
        if (this.type == Type.TAKE) {
            ItemStack stack = drawerItem.takeItem(drawer, (Player)player);
            if (player.m_7500_() && this.wid == 0) {
                carried = stack;
            } else {
                menu.m_142503_(stack);
            }
            if (!stack.m_41619_()) {
                BackpackTriggers.DRAWER.trigger(player, Type.TAKE);
            }
        } else if (this.type == Type.INSERT) {
            if (BaseDrawerItem.canAccept(drawer, carried) && !carried.m_41619_() && !carried.m_41782_()) {
                drawerItem.insert(drawer, carried, (Player)player);
                BackpackTriggers.DRAWER.trigger(player, Type.INSERT);
            }
        } else if (this.type == Type.SET && drawerItem.canSetNewItem(drawer) && !carried.m_41619_() && !carried.m_41782_()) {
            drawerItem.setItem(drawer, carried.m_41720_(), (Player)player);
            drawerItem.insert(drawer, carried, (Player)player);
            BackpackTriggers.DRAWER.trigger(player, Type.INSERT);
        }
        menu.m_38853_(this.slot).m_6654_();
        if (player.m_7500_() && this.wid == 0) {
            L2Backpack.HANDLER.toClientPlayer((SimplePacketBase)new CreativeSetCarryToClient(carried), player);
        }
    }

    public static enum Type {
        SET,
        INSERT,
        TAKE;

    }
}

