/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.init.registrate;

import dev.xkmc.l2backpack.content.backpack.BackpackItem;
import dev.xkmc.l2backpack.content.backpack.EnderBackpackItem;
import dev.xkmc.l2backpack.content.bag.BookBag;
import dev.xkmc.l2backpack.content.bag.EquipmentBag;
import dev.xkmc.l2backpack.content.drawer.DrawerItem;
import dev.xkmc.l2backpack.content.quickswap.armorswap.ArmorSwap;
import dev.xkmc.l2backpack.content.quickswap.merged.EnderSwitch;
import dev.xkmc.l2backpack.content.quickswap.merged.MultiSwitch;
import dev.xkmc.l2backpack.content.quickswap.quiver.Quiver;
import dev.xkmc.l2backpack.content.quickswap.scabbard.Scabbard;
import dev.xkmc.l2backpack.content.remote.drawer.EnderDrawerItem;
import dev.xkmc.l2backpack.content.remote.worldchest.WorldChestItem;
import dev.xkmc.l2backpack.init.L2Backpack;
import dev.xkmc.l2backpack.init.data.TagGen;
import dev.xkmc.l2backpack.init.registrate.BackpackBlocks;
import dev.xkmc.l2library.repack.registrate.providers.DataGenContext;
import dev.xkmc.l2library.repack.registrate.providers.RegistrateItemModelProvider;
import dev.xkmc.l2library.repack.registrate.providers.RegistrateLangProvider;
import dev.xkmc.l2library.repack.registrate.util.entry.ItemEntry;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

@MethodsReturnNonnullByDefault
public class BackpackItems {
    public static final Tab TAB_MAIN;
    public static final ItemEntry<BackpackItem>[] BACKPACKS;
    public static final ItemEntry<WorldChestItem>[] DIMENSIONAL_STORAGE;
    public static final ItemEntry<EnderBackpackItem> ENDER_BACKPACK;
    public static final ItemEntry<Item> ENDER_POCKET;
    public static final ItemEntry<EquipmentBag> ARMOR_BAG;
    public static final ItemEntry<BookBag> BOOK_BAG;
    public static final ItemEntry<Quiver> QUIVER;
    public static final ItemEntry<Scabbard> SCABBARD;
    public static final ItemEntry<ArmorSwap> ARMOR_SWAP;
    public static final ItemEntry<MultiSwitch> MULTI_SWITCH;
    public static final ItemEntry<EnderSwitch> ENDER_SWITCH;
    public static final ItemEntry<DrawerItem> DRAWER;
    public static final ItemEntry<EnderDrawerItem> ENDER_DRAWER;

    private static void createBackpackModel(DataGenContext<Item, BackpackItem> ctx, RegistrateItemModelProvider pvd) {
        ItemModelBuilder builder = (ItemModelBuilder)pvd.withExistingParent(ctx.getName(), "l2backpack:backpack");
        builder.override().predicate(new ResourceLocation("open"), 1.0f).model((ModelFile)new ModelFile.UncheckedModelFile("l2backpack:item/backpack_open"));
    }

    private static void createWorldChestModel(DataGenContext<Item, WorldChestItem> ctx, RegistrateItemModelProvider pvd) {
        ItemModelBuilder builder = (ItemModelBuilder)pvd.withExistingParent(ctx.getName(), "l2backpack:dimensional_storage");
    }

    private static void createEnderBackpackModel(DataGenContext<Item, EnderBackpackItem> ctx, RegistrateItemModelProvider pvd) {
        ((ItemModelBuilder)pvd.withExistingParent("ender_backpack_open", "generated")).texture("layer0", "item/ender_backpack_open");
        ItemModelBuilder builder = (ItemModelBuilder)pvd.withExistingParent("ender_backpack", "generated");
        builder.texture("layer0", "item/ender_backpack");
        builder.override().predicate(new ResourceLocation("open"), 1.0f).model((ModelFile)new ModelFile.UncheckedModelFile("l2backpack:item/ender_backpack_open"));
    }

    public static <T extends Quiver> void createArrowBagModel(DataGenContext<Item, T> ctx, RegistrateItemModelProvider pvd) {
        ItemModelBuilder builder = (ItemModelBuilder)pvd.withExistingParent(ctx.getName(), "generated");
        builder.texture("layer0", "item/" + ctx.getName() + "_0");
        for (int i = 1; i < 4; ++i) {
            String name = ctx.getName() + "_" + i;
            ItemModelBuilder ret = (ItemModelBuilder)pvd.withExistingParent(name, "generated");
            ret.texture("layer0", "item/" + name);
            ItemModelBuilder.OverrideBuilder override = builder.override();
            override.predicate(new ResourceLocation("l2backpack", "arrow"), (float)i);
            override.model((ModelFile)new ModelFile.UncheckedModelFile("l2backpack:item/" + name));
        }
    }

    public static void register() {
    }

    public static ItemEntry<Item> simpleItem(String id) {
        return L2Backpack.REGISTRATE.item(id, Item::new).defaultModel().defaultLang().register();
    }

    static {
        DyeColor color;
        int i;
        TAB_MAIN = new Tab("backpack", () -> ENDER_BACKPACK);
        L2Backpack.REGISTRATE.creativeModeTab(() -> TAB_MAIN);
        ITagManager manager = Objects.requireNonNull(ForgeRegistries.ITEMS.tags());
        TagKey curios_tag = manager.createTagKey(new ResourceLocation("curios", "back"));
        BACKPACKS = new ItemEntry[16];
        for (i = 0; i < 16; ++i) {
            color = DyeColor.values()[i];
            BackpackItems.BACKPACKS[i] = L2Backpack.REGISTRATE.item("backpack_" + color.m_41065_(), p -> new BackpackItem(color, (Item.Properties)p)).tag(new TagKey[]{TagGen.BACKPACKS, curios_tag}).model(BackpackItems::createBackpackModel).color(() -> () -> (stack, val) -> val == 0 ? -1 : ((BackpackItem)stack.m_41720_()).color.m_41069_().f_76396_).lang(RegistrateLangProvider.toEnglishName((String)(color.m_41065_() + "_backpack"))).register();
        }
        DIMENSIONAL_STORAGE = new ItemEntry[16];
        for (i = 0; i < 16; ++i) {
            color = DyeColor.values()[i];
            BackpackItems.DIMENSIONAL_STORAGE[i] = L2Backpack.REGISTRATE.item("dimensional_storage_" + color.m_41065_(), p -> new WorldChestItem(color, (Item.Properties)p)).tag(new TagKey[]{TagGen.DIMENSIONAL_STORAGES, curios_tag}).model(BackpackItems::createWorldChestModel).color(() -> () -> (stack, val) -> val == 0 ? -1 : ((WorldChestItem)stack.m_41720_()).color.m_41069_().f_76396_).lang(RegistrateLangProvider.toEnglishName((String)(color.m_41065_() + "_dimensional_backpack"))).register();
        }
        ENDER_BACKPACK = L2Backpack.REGISTRATE.item("ender_backpack", EnderBackpackItem::new).model(BackpackItems::createEnderBackpackModel).tag(new TagKey[]{curios_tag}).defaultLang().register();
        ENDER_POCKET = BackpackItems.simpleItem("ender_pocket");
        ARMOR_BAG = L2Backpack.REGISTRATE.item("armor_bag", EquipmentBag::new).lang("Equipment Bag").register();
        BOOK_BAG = L2Backpack.REGISTRATE.item("book_bag", BookBag::new).defaultLang().register();
        QUIVER = L2Backpack.REGISTRATE.item("arrow_bag", Quiver::new).model(BackpackItems::createArrowBagModel).tag(new TagKey[]{curios_tag}).lang("Quiver").register();
        SCABBARD = L2Backpack.REGISTRATE.item("tool_swap", Scabbard::new).tag(new TagKey[]{curios_tag}).defaultLang().register();
        ARMOR_SWAP = L2Backpack.REGISTRATE.item("armor_swap", ArmorSwap::new).tag(new TagKey[]{curios_tag}).defaultLang().register();
        MULTI_SWITCH = L2Backpack.REGISTRATE.item("combined_swap", MultiSwitch::new).tag(new TagKey[]{curios_tag}).defaultLang().register();
        ENDER_SWITCH = L2Backpack.REGISTRATE.item("ender_swap", EnderSwitch::new).tag(new TagKey[]{curios_tag}).defaultLang().register();
        DRAWER = L2Backpack.REGISTRATE.item("drawer", p -> new DrawerItem((Block)BackpackBlocks.DRAWER.get(), (Item.Properties)p)).model((ctx, pvd) -> ((ItemModelBuilder)pvd.getBuilder(ctx.getName())).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).defaultLang().register();
        ENDER_DRAWER = L2Backpack.REGISTRATE.item("ender_drawer", p -> new EnderDrawerItem((Block)BackpackBlocks.ENDER_DRAWER.get(), (Item.Properties)p)).model((ctx, pvd) -> ((ItemModelBuilder)pvd.getBuilder(ctx.getName())).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).defaultLang().register();
    }

    public static class Tab
    extends CreativeModeTab {
        private final Supplier<ItemEntry> icon;

        public Tab(String id, Supplier<ItemEntry> icon) {
            super("l2backpack." + id);
            this.icon = icon;
        }

        public ItemStack m_6976_() {
            return this.icon.get().asStack();
        }
    }
}

