/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.init.data;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class BackpackConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    public static void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_SPEC);
    }

    static {
        Pair client = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)client.getRight();
        CLIENT = (Client)client.getLeft();
        Pair common = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)common.getRight();
        COMMON = (Common)common.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue previewOnCenter;
        public final ForgeConfigSpec.BooleanValue showArrowOnlyWithShift;
        public final ForgeConfigSpec.BooleanValue showToolOnlyWithShift;
        public final ForgeConfigSpec.BooleanValue showArmorOnlyWithShift;

        Client(ForgeConfigSpec.Builder builder) {
            this.previewOnCenter = builder.comment("Put quiver preview near the center of the screen, rather than edge of the screen").define("previewOnCenter", true);
            this.showArrowOnlyWithShift = builder.comment("Show arrow quick swap only when shift is pressed").define("showArrowOnlyWithShift", false);
            this.showToolOnlyWithShift = builder.comment("Show arrow quick swap only when shift is pressed").define("showToolOnlyWithShift", true);
            this.showArmorOnlyWithShift = builder.comment("Show arrow quick swap only when shift is pressed").define("showArmorOnlyWithShift", true);
        }
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue initialRows;

        Common(ForgeConfigSpec.Builder builder) {
            this.initialRows = builder.comment("Initial Rows (x9 slots) for backpack").defineInRange("initialRows", 2, 1, 6);
        }
    }
}

