/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.events;

import dev.xkmc.l2backpack.compat.CuriosCompat;
import dev.xkmc.l2backpack.content.backpack.EnderBackpackItem;
import dev.xkmc.l2backpack.content.common.BaseBagItem;
import dev.xkmc.l2backpack.content.drawer.BaseDrawerItem;
import dev.xkmc.l2backpack.content.remote.worldchest.WorldChestItem;
import dev.xkmc.l2backpack.events.quickaccess.QuickAccessClickHandler;
import dev.xkmc.l2backpack.init.L2Backpack;
import dev.xkmc.l2backpack.init.data.Keys;
import dev.xkmc.l2backpack.init.data.LangData;
import dev.xkmc.l2backpack.network.SlotClickToServer;
import dev.xkmc.l2backpack.network.drawer.DrawerInteractToServer;
import dev.xkmc.l2library.serial.network.SimplePacketBase;
import dev.xkmc.l2library.util.Proxy;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientEventHandler {
    public static boolean canOpen(ItemStack stack) {
        return stack.m_41720_() instanceof BaseBagItem || stack.m_41720_() instanceof EnderBackpackItem || stack.m_41720_() instanceof WorldChestItem;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void keyEvent(InputEvent.Key event) {
        if (Minecraft.m_91087_().f_91080_ == null && Proxy.getClientPlayer() != null && Keys.OPEN.map.m_90857_() && (ClientEventHandler.canOpen(Proxy.getClientPlayer().m_6844_(EquipmentSlot.CHEST)) || !CuriosCompat.getSlot((Player)Proxy.getClientPlayer(), ClientEventHandler::canOpen).m_41619_())) {
            L2Backpack.HANDLER.toServer((SimplePacketBase)new SlotClickToServer(-1, -1, -1));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onScreenLeftClick(ScreenEvent.MouseButtonReleased.Pre event) {
        if (ClientEventHandler.onRelease(event)) {
            event.setCanceled(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onScreenRightClick(ScreenEvent.MouseButtonPressed.Pre event) {
        if (ClientEventHandler.onPress(event)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onTooltipEvent(ItemTooltipEvent event) {
        if (QuickAccessClickHandler.isAllowed(event.getItemStack())) {
            event.getToolTip().add(LangData.Info.QUICK_ACCESS.get().m_130940_(ChatFormatting.GRAY));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean onRelease(ScreenEvent.MouseButtonReleased.Pre event) {
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen cont = (AbstractContainerScreen)screen;
            Slot slot = cont.getSlotUnderMouse();
            if (event.getButton() == 0 && ClientEventHandler.insertItem((ScreenEvent)event, cont, slot, true)) {
                return true;
            }
            if (event.getButton() == 1 && slot != null) {
                return slot.m_7993_().m_41720_() instanceof BaseDrawerItem && !cont.m_6262_().m_142621_().m_41619_();
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean onPress(ScreenEvent.MouseButtonPressed.Pre event) {
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen cont = (AbstractContainerScreen)screen;
            Slot slot = cont.getSlotUnderMouse();
            if (event.getButton() == 0 && ClientEventHandler.insertItem((ScreenEvent)event, cont, slot, false)) {
                return true;
            }
            if (event.getButton() == 1) {
                if (ClientEventHandler.openBackpack(event, cont, slot)) {
                    return true;
                }
                if (ClientEventHandler.extractItem(event, cont, slot)) {
                    return true;
                }
                if (slot != null) {
                    return slot.m_7993_().m_41720_() instanceof BaseDrawerItem && !cont.m_6262_().m_142621_().m_41619_();
                }
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean openBackpack(ScreenEvent.MouseButtonPressed.Pre event, AbstractContainerScreen<?> cont, @Nullable Slot slot) {
        boolean b2;
        if (slot == null) {
            return false;
        }
        boolean b1 = slot.f_40218_ == Proxy.getClientPlayer().m_150109_();
        boolean bl = b2 = cont.m_6262_().f_38840_ > 0;
        if (b1 || b2) {
            int inv = b1 ? slot.getSlotIndex() : -1;
            int ind = inv == -1 ? slot.f_40219_ : -1;
            int wid = cont.m_6262_().f_38840_;
            ItemStack stack = slot.m_7993_();
            if ((inv >= 0 || ind >= 0) && (stack.m_41720_() instanceof EnderBackpackItem || stack.m_41720_() instanceof WorldChestItem || stack.m_41720_() instanceof BaseBagItem || QuickAccessClickHandler.isAllowed(stack) && stack.m_41613_() == 1)) {
                L2Backpack.HANDLER.toServer((SimplePacketBase)new SlotClickToServer(ind, inv, wid));
                return true;
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean insertItem(ScreenEvent event, AbstractContainerScreen<?> cont, @Nullable Slot slot, boolean perform) {
        if (slot == null || !slot.m_150651_((Player)Proxy.getClientPlayer())) {
            return false;
        }
        ItemStack drawerStack = slot.m_7993_();
        ItemStack stack = cont.m_6262_().m_142621_();
        Item item = drawerStack.m_41720_();
        if (item instanceof BaseDrawerItem) {
            BaseDrawerItem drawer = (BaseDrawerItem)item;
            if (stack.m_41619_()) {
                return false;
            }
            if (stack.m_41782_()) {
                return true;
            }
            if (drawer.canSetNewItem(drawerStack)) {
                if (perform) {
                    ClientEventHandler.sendDrawerPacket(DrawerInteractToServer.Type.SET, cont, slot);
                }
                return true;
            }
            if (BaseDrawerItem.canAccept(drawerStack, stack)) {
                if (perform) {
                    ClientEventHandler.sendDrawerPacket(DrawerInteractToServer.Type.INSERT, cont, slot);
                }
                return true;
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean extractItem(ScreenEvent.MouseButtonPressed.Pre event, AbstractContainerScreen<?> cont, @Nullable Slot slot) {
        if (slot == null || !slot.m_150651_((Player)Proxy.getClientPlayer())) {
            return false;
        }
        ItemStack stack = cont.m_6262_().m_142621_();
        ItemStack drawerStack = slot.m_7993_();
        Item item = drawerStack.m_41720_();
        if (item instanceof BaseDrawerItem) {
            BaseDrawerItem drawer = (BaseDrawerItem)item;
            if (stack.m_41619_()) {
                ClientEventHandler.sendDrawerPacket(DrawerInteractToServer.Type.TAKE, cont, slot);
                return true;
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void sendDrawerPacket(DrawerInteractToServer.Type type, AbstractContainerScreen<?> cont, Slot slot) {
        int index = cont.m_6262_().f_38840_ == 0 ? slot.getSlotIndex() : slot.f_40219_;
        L2Backpack.HANDLER.toServer((SimplePacketBase)new DrawerInteractToServer(type, cont.m_6262_().f_38840_, index, cont.m_6262_().m_142621_()));
    }
}

