/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.restore;

import dev.xkmc.l2backpack.compat.CuriosCompat;
import dev.xkmc.l2backpack.content.common.BaseOpenableContainer;
import dev.xkmc.l2backpack.content.common.ContainerType;
import dev.xkmc.l2backpack.content.remote.common.StorageContainer;
import dev.xkmc.l2backpack.content.remote.common.WorldStorage;
import dev.xkmc.l2backpack.content.remote.worldchest.SimpleStorageMenuPvd;
import dev.xkmc.l2backpack.content.remote.worldchest.WorldChestContainer;
import dev.xkmc.l2backpack.content.restore.LayerPopType;
import dev.xkmc.l2backpack.content.restore.ScreenType;
import dev.xkmc.l2backpack.init.L2Backpack;
import dev.xkmc.l2backpack.init.registrate.BackpackMenu;
import dev.xkmc.l2backpack.network.restore.SetScreenToClient;
import dev.xkmc.l2library.serial.network.SimplePacketBase;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.network.NetworkHooks;

public record TrackedEntry(ContainerType type, UUID id, int slot, String title) {
    public static TrackedEntry of(ContainerType type, UUID uuid, int color, @Nullable Component title) {
        String str = title == null ? "" : Component.Serializer.m_130703_((Component)title);
        return new TrackedEntry(type, uuid, color, str);
    }

    public boolean match(BaseOpenableContainer<?> current) {
        if (this.type == ContainerType.DIMENSION) {
            WorldChestContainer chest;
            return current instanceof WorldChestContainer && (chest = (WorldChestContainer)current).getColor() == this.slot && chest.getOwner().equals(this.id);
        }
        return false;
    }

    public LayerPopType restoreServerMenu(ServerPlayer player) {
        MutableComponent comp = Component.Serializer.m_130701_((String)this.title);
        if (this.type == ContainerType.INVENTORY) {
            L2Backpack.HANDLER.toClientPlayer((SimplePacketBase)new SetScreenToClient(ScreenType.PLAYER), player);
            return LayerPopType.CLEAR;
        }
        if (this.type == ContainerType.CURIO) {
            return CuriosCompat.openCurio(player) ? LayerPopType.CLEAR : LayerPopType.FAIL;
        }
        if (this.type == ContainerType.ENDER) {
            if (comp == null) {
                comp = Component.m_237115_((String)"container.enderchest");
            }
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((wid, inv, pl) -> ChestMenu.m_39237_((int)wid, (Inventory)inv, (Container)pl.m_36327_()), (Component)comp));
            return LayerPopType.CLEAR;
        }
        if (this.type == ContainerType.DIMENSION) {
            Optional<StorageContainer> op;
            if (comp == null) {
                comp = Component.m_237115_((String)BackpackMenu.getLangKey((MenuType)BackpackMenu.MT_WORLD_CHEST.get()));
            }
            if ((op = WorldStorage.get(player.m_9236_()).getStorageWithoutPassword(this.id, this.slot)).isPresent()) {
                NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SimpleStorageMenuPvd((Component)comp, op.get()));
                return LayerPopType.REMAIN;
            }
        }
        return LayerPopType.FAIL;
    }
}

