/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.render;

import dev.xkmc.l2backpack.content.render.BackpackLayerRenderer;
import dev.xkmc.l2backpack.content.render.BackpackModel;
import dev.xkmc.l2backpack.content.render.ItemOnBackLayerRenderer;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.eventbus.api.IEventBus;

@OnlyIn(value=Dist.CLIENT)
public class RenderEvents {
    private static final String REG_NAME = "backpack";
    public static final ModelLayerLocation BACKPACK_LAYER = new ModelLayerLocation(new ResourceLocation("l2backpack", "backpack"), "main");

    public static void register(IEventBus bus) {
        bus.addListener(RenderEvents::registerReloadListener);
        bus.addListener(RenderEvents::registerLayer);
    }

    private static void onModelRegistry(ModelEvent.RegisterGeometryLoaders event) {
    }

    public static void registerReloadListener(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)((ResourceManagerReloadListener)resourceManager -> RenderEvents.registerBackpackLayer()));
    }

    private static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
    }

    public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(BACKPACK_LAYER, BackpackModel::createBodyLayer);
    }

    private static void registerBackpackLayer() {
        EntityRenderDispatcher renderManager = Minecraft.m_91087_().m_91290_();
        Map skinMap = renderManager.getSkinMap();
        for (EntityRenderer renderer : skinMap.values()) {
            if (!(renderer instanceof LivingEntityRenderer)) continue;
            LivingEntityRenderer ler = (LivingEntityRenderer)renderer;
            RenderEvents.addLayer(renderManager, ler);
        }
        renderManager.f_114362_.forEach((e, r) -> {
            LivingEntityRenderer ler;
            if (r instanceof LivingEntityRenderer && (ler = (LivingEntityRenderer)r).m_7200_() instanceof HumanoidModel) {
                RenderEvents.addLayer(renderManager, ler);
            }
        });
    }

    private static <T extends LivingEntity, M extends HumanoidModel<T>> void addLayer(EntityRenderDispatcher manager, LivingEntityRenderer<T, M> ler) {
        Minecraft mc = Minecraft.m_91087_();
        ler.m_115326_(new BackpackLayerRenderer<T, M>(ler, mc.m_167973_()));
        ler.m_115326_(new ItemOnBackLayerRenderer<T, M>(ler, mc.m_167973_(), manager.m_234586_()));
    }
}

