/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.remote.worldchest;

import dev.xkmc.l2backpack.content.common.BackpackModelItem;
import dev.xkmc.l2backpack.content.common.ContentTransfer;
import dev.xkmc.l2backpack.content.remote.common.StorageContainer;
import dev.xkmc.l2backpack.content.remote.common.WorldStorage;
import dev.xkmc.l2backpack.content.remote.worldchest.WorldChestMenuPvd;
import dev.xkmc.l2backpack.init.data.LangData;
import dev.xkmc.l2backpack.init.registrate.BackpackBlocks;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class WorldChestItem
extends BlockItem
implements BackpackModelItem {
    public final DyeColor color;

    public static Optional<UUID> getOwner(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("owner_id")) {
            return Optional.of(tag.m_128342_("owner_id"));
        }
        return Optional.empty();
    }

    public WorldChestItem(DyeColor color, Item.Properties props) {
        super((Block)BackpackBlocks.WORLD_CHEST.get(), props.m_41487_(1).m_41486_());
        this.color = color;
    }

    void refresh(ItemStack stack, Player player) {
        if (!stack.m_41784_().m_128441_("owner_id")) {
            stack.m_41784_().m_128362_("owner_id", player.m_20148_());
            stack.m_41784_().m_128359_("owner_name", player.m_7755_().getString());
            stack.m_41784_().m_128356_("password", (long)this.color.m_41060_());
        }
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> list) {
        if (super.m_220152_(tab)) {
            list.add((Object)new ItemStack((ItemLike)this));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.m_5776_()) {
            new WorldChestMenuPvd((ServerPlayer)player, stack, this).open();
        } else {
            ContentTransfer.playSound(player);
        }
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (!context.m_43725_().m_5776_() && context.m_43723_() != null) {
            this.refresh(context.m_43722_(), context.m_43723_());
        }
        if (context.m_43723_() != null && !context.m_43723_().m_6047_()) {
            ItemStack stack = context.m_43722_();
            if (!context.m_43725_().m_5776_()) {
                new WorldChestMenuPvd((ServerPlayer)context.m_43723_(), stack, this).open();
            } else {
                ContentTransfer.playSound(context.m_43723_());
            }
            return InteractionResult.SUCCESS;
        }
        if (!context.m_43722_().m_41784_().m_128441_("owner_id")) {
            return InteractionResult.FAIL;
        }
        return super.m_6225_(context);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("owner_name")) {
            String name = tag.m_128461_("owner_name");
            list.add((Component)LangData.IDS.STORAGE_OWNER.get(name));
        }
        LangData.addInfo(list, LangData.Info.QUICK_ANY_ACCESS, LangData.Info.PLACE, LangData.Info.DIMENSIONAL, LangData.Info.KEYBIND, LangData.Info.EXIT);
    }

    public String m_5524_() {
        return this.m_41467_();
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, Entity entity) {
        return armorType == EquipmentSlot.CHEST;
    }

    @Override
    public ResourceLocation getModelTexture(ItemStack stack) {
        return new ResourceLocation("l2backpack", "textures/block/dimensional_storage/" + this.color.m_41065_() + ".png");
    }

    public Optional<StorageContainer> getContainer(ItemStack stack, ServerLevel level) {
        if (!stack.m_41782_()) {
            return Optional.empty();
        }
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_("owner_id")) {
            return Optional.empty();
        }
        UUID id = tag.m_128342_("owner_id");
        long pwd = tag.m_128454_("password");
        return WorldStorage.get(level).getOrCreateStorage(id, this.color.m_41060_(), pwd);
    }
}

