/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.remote.worldchest;

import dev.xkmc.l2backpack.content.common.ContentTransfer;
import dev.xkmc.l2backpack.content.remote.worldchest.WorldChestAnalogBlockEntity;
import dev.xkmc.l2backpack.content.remote.worldchest.WorldChestBlockEntity;
import dev.xkmc.l2backpack.content.remote.worldchest.WorldChestItem;
import dev.xkmc.l2backpack.init.registrate.BackpackBlocks;
import dev.xkmc.l2backpack.init.registrate.BackpackItems;
import dev.xkmc.l2library.block.mult.CreateBlockStateBlockMethod;
import dev.xkmc.l2library.block.mult.DefaultStateBlockMethod;
import dev.xkmc.l2library.block.mult.OnClickBlockMethod;
import dev.xkmc.l2library.block.mult.PlacementBlockMethod;
import dev.xkmc.l2library.block.mult.SetPlacedByBlockMethod;
import dev.xkmc.l2library.block.one.BlockEntityBlockMethod;
import dev.xkmc.l2library.block.one.GetBlockItemBlockMethod;
import dev.xkmc.l2library.block.one.ShapeBlockMethod;
import dev.xkmc.l2library.block.one.SpecialDropBlockMethod;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WorldChestBlock
implements CreateBlockStateBlockMethod,
DefaultStateBlockMethod,
PlacementBlockMethod,
OnClickBlockMethod,
GetBlockItemBlockMethod,
SpecialDropBlockMethod,
SetPlacedByBlockMethod,
ShapeBlockMethod {
    public static final WorldChestBlock INSTANCE = new WorldChestBlock();
    protected static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    public static final BlockEntityBlockMethod<WorldChestBlockEntity> TILE_ENTITY_SUPPLIER_BUILDER = new WorldChestAnalogBlockEntity<WorldChestBlockEntity>(BackpackBlocks.TE_WORLD_CHEST, WorldChestBlockEntity.class);
    public static final EnumProperty<DyeColor> COLOR = EnumProperty.m_61587_((String)"color", DyeColor.class);

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{COLOR});
    }

    public BlockState getDefaultState(BlockState state) {
        return (BlockState)state.m_61124_(COLOR, (Comparable)DyeColor.WHITE);
    }

    public InteractionResult onClick(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof WorldChestBlockEntity) {
            WorldChestBlockEntity chest = (WorldChestBlockEntity)blockentity;
            ItemStack stack = player.m_21120_(hand);
            Item item = stack.m_41720_();
            if (item instanceof DyeItem) {
                DyeItem dye = (DyeItem)item;
                if (!level.m_5776_()) {
                    level.m_46597_(pos, (BlockState)state.m_61124_(COLOR, (Comparable)dye.m_41089_()));
                    chest.setColor(dye.m_41089_().m_41060_());
                } else {
                    ContentTransfer.playSound(player);
                }
                return InteractionResult.SUCCESS;
            }
            BlockPos blockpos = pos.m_7494_();
            if (level.m_8055_(blockpos).m_60796_((BlockGetter)level, blockpos)) {
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (level.f_46443_) {
                ContentTransfer.playSound(player);
                return InteractionResult.SUCCESS;
            }
            player.m_5893_((MenuProvider)chest);
            PiglinAi.m_34873_((Player)player, (boolean)true);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public ItemStack getCloneItemStack(BlockGetter world, BlockPos pos, BlockState state) {
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof WorldChestBlockEntity) {
            WorldChestBlockEntity chest = (WorldChestBlockEntity)be;
            return this.buildStack(state, chest);
        }
        return BackpackItems.DIMENSIONAL_STORAGE[((DyeColor)state.m_61143_(COLOR)).m_41060_()].asStack();
    }

    public List<ItemStack> getDrops(BlockState state, LootContext.Builder builder) {
        BlockEntity blockentity = (BlockEntity)builder.m_78982_(LootContextParams.f_81462_);
        if (blockentity instanceof WorldChestBlockEntity) {
            WorldChestBlockEntity chest = (WorldChestBlockEntity)blockentity;
            return List.of(this.buildStack(state, chest));
        }
        return List.of(BackpackItems.DIMENSIONAL_STORAGE[((DyeColor)state.m_61143_(COLOR)).m_41060_()].asStack());
    }

    private ItemStack buildStack(BlockState state, WorldChestBlockEntity chest) {
        ItemStack stack = BackpackItems.DIMENSIONAL_STORAGE[((DyeColor)state.m_61143_(COLOR)).m_41060_()].asStack();
        if (chest.owner_id != null) {
            stack.m_41784_().m_128362_("owner_id", chest.owner_id);
            stack.m_41784_().m_128359_("owner_name", chest.owner_name);
            stack.m_41784_().m_128356_("password", chest.password);
        }
        return stack;
    }

    public BlockState getStateForPlacement(BlockState def, BlockPlaceContext context) {
        return (BlockState)def.m_61124_(COLOR, (Comparable)((WorldChestItem)context.m_43722_().m_41720_()).color);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity blockentity = level.m_7702_(pos);
        UUID id = stack.m_41784_().m_128342_("owner_id");
        String name = stack.m_41784_().m_128461_("owner_name");
        long pwd = stack.m_41784_().m_128454_("password");
        if (blockentity instanceof WorldChestBlockEntity) {
            WorldChestBlockEntity chest = (WorldChestBlockEntity)blockentity;
            chest.owner_id = id;
            chest.owner_name = name;
            chest.password = pwd;
            chest.setColor(((DyeColor)state.m_61143_(COLOR)).m_41060_());
            chest.addToListener();
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }
}

