/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.remote.drawer;

import dev.xkmc.l2backpack.content.common.BaseItemRenderer;
import dev.xkmc.l2backpack.content.common.ContentTransfer;
import dev.xkmc.l2backpack.content.drawer.BaseDrawerItem;
import dev.xkmc.l2backpack.content.remote.common.DrawerAccess;
import dev.xkmc.l2backpack.events.TooltipUpdateEvents;
import dev.xkmc.l2backpack.init.data.LangData;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;

public class EnderDrawerItem
extends BlockItem
implements BaseDrawerItem {
    public static final String KEY_OWNER_ID = "owner_id";
    public static final String KEY_OWNER_NAME = "owner_name";
    public static final int MAX = 64;

    public static Optional<UUID> getOwner(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(KEY_OWNER_ID)) {
            return Optional.of(tag.m_128342_(KEY_OWNER_ID));
        }
        return Optional.empty();
    }

    public EnderDrawerItem(Block block, Item.Properties properties) {
        super(block, properties.m_41487_(1).m_41486_());
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(BaseItemRenderer.EXTENSIONS);
    }

    void refresh(ItemStack drawer, Player player) {
        if (!drawer.m_41784_().m_128441_(KEY_OWNER_ID)) {
            drawer.m_41784_().m_128362_(KEY_OWNER_ID, player.m_20148_());
            drawer.m_41784_().m_128359_(KEY_OWNER_NAME, player.m_7755_().getString());
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (BaseDrawerItem.getItem(stack) == Items.f_41852_) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (world.m_5776_()) {
            ContentTransfer.playDrawerSound(player);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        this.refresh(stack, player);
        if (!player.m_6144_()) {
            ItemStack take = this.takeItem(stack, player);
            int c = take.m_41613_();
            player.m_150109_().m_150079_(take);
            ContentTransfer.onExtract(player, c, stack);
        } else {
            DrawerAccess access = DrawerAccess.of(world, stack);
            int count = access.getCount();
            int max = 64 * access.item().m_41459_();
            int ext = BaseDrawerItem.loadFromInventory(max, count, access.item(), player);
            access.setCount(count += ext);
            ContentTransfer.onCollect(player, ext, stack);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (!context.m_43725_().m_5776_() && context.m_43723_() != null) {
            this.refresh(context.m_43722_(), context.m_43723_());
        }
        if (!context.m_43722_().m_41784_().m_128441_(KEY_OWNER_ID)) {
            return InteractionResult.FAIL;
        }
        if (BaseDrawerItem.getItem(context.m_43722_()) == Items.f_41852_) {
            Player player;
            if (!context.m_43725_().m_5776_() && (player = context.m_43723_()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.m_240418_((Component)LangData.IDS.NO_ITEM.get(new Object[0]).m_130940_(ChatFormatting.RED), true);
            }
            return InteractionResult.FAIL;
        }
        if (context.m_43723_() != null && !context.m_43723_().m_6144_()) {
            return InteractionResult.PASS;
        }
        InteractionResult result = super.m_6225_(context);
        if (result == InteractionResult.FAIL) {
            return InteractionResult.PASS;
        }
        return result;
    }

    @Override
    public void insert(ItemStack drawer, ItemStack stack, Player player) {
        this.refresh(drawer, player);
        DrawerAccess access = DrawerAccess.of(player.m_9236_(), drawer);
        int count = access.getCount();
        int take = Math.min(64 * stack.m_41741_() - count, stack.m_41613_());
        access.setCount(access.getCount() + take);
        stack.m_41774_(take);
    }

    @Override
    public ItemStack takeItem(ItemStack drawer, Player player) {
        this.refresh(drawer, player);
        DrawerAccess access = DrawerAccess.of(player.m_9236_(), drawer);
        Item item = BaseDrawerItem.getItem(drawer);
        int take = Math.min(access.getCount(), item.m_41459_());
        access.setCount(access.getCount() - take);
        return new ItemStack((ItemLike)item, take);
    }

    @Override
    public boolean canSetNewItem(ItemStack drawer) {
        return BaseDrawerItem.getItem(drawer) == Items.f_41852_;
    }

    @Override
    public void setItem(ItemStack drawer, Item item, Player player) {
        this.refresh(drawer, player);
        BaseDrawerItem.super.setItem(drawer, item, player);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        CompoundTag tag;
        Item item = BaseDrawerItem.getItem(stack);
        if (item != Items.f_41852_) {
            int count = TooltipUpdateEvents.getCount(stack.m_41784_().m_128342_(KEY_OWNER_ID), item);
            list.add((Component)LangData.IDS.DRAWER_CONTENT.get(item.m_41466_(), count < 0 ? "???" : Integer.valueOf(count)));
        }
        if ((tag = stack.m_41783_()) != null && tag.m_128441_(KEY_OWNER_NAME)) {
            String name = tag.m_128461_(KEY_OWNER_NAME);
            list.add((Component)LangData.IDS.STORAGE_OWNER.get(name));
        }
        LangData.addInfo(list, LangData.Info.DRAWER_USE, LangData.Info.EXTRACT_DRAWER, LangData.Info.PLACE, LangData.Info.COLLECT_DRAWER, LangData.Info.ENDER_DRAWER, LangData.Info.ENDER_DRAWER_USE);
    }

    public String m_5524_() {
        return this.m_41467_();
    }
}

