/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.remote.drawer;

import dev.xkmc.l2backpack.content.drawer.IDrawerBlockEntity;
import dev.xkmc.l2backpack.content.remote.common.DrawerAccess;
import dev.xkmc.l2backpack.content.remote.drawer.EnderDawerItemHandler;
import dev.xkmc.l2library.serial.SerialClass;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class EnderDrawerBlockEntity
extends IDrawerBlockEntity {
    @SerialClass.SerialField(toClient=true)
    public UUID owner_id;
    @SerialClass.SerialField(toClient=true)
    public String owner_name;
    @SerialClass.SerialField(toClient=true)
    public Item item;
    private LazyOptional<IItemHandler> handler;
    private boolean added = false;

    public EnderDrawerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.f_58857_ != null && !this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER) {
            if (this.f_58857_.m_5776_()) {
                return LazyOptional.of(() -> new InvWrapper((Container)new SimpleContainer(64))).cast();
            }
            if (this.handler == null) {
                this.handler = this.owner_id == null ? LazyOptional.empty() : LazyOptional.of(() -> new EnderDawerItemHandler(this.getAccess(), true));
            }
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public DrawerAccess getAccess() {
        return DrawerAccess.of(this.f_58857_, this.owner_id, this.item);
    }

    public void onChunkUnloaded() {
        this.removeFromListener();
        super.onChunkUnloaded();
    }

    public void m_7651_() {
        this.removeFromListener();
        super.m_7651_();
    }

    public void onLoad() {
        super.onLoad();
        this.addToListener();
    }

    public void addToListener() {
        if (!this.added && this.f_58857_ != null && !this.f_58857_.m_5776_() && this.owner_id != null) {
            this.added = true;
            this.getAccess().listener.add(this);
        }
    }

    public void removeFromListener() {
        if (this.added && this.f_58857_ != null && !this.f_58857_.m_5776_() && this.owner_id != null) {
            this.added = false;
            this.getAccess().listener.remove((Object)this);
        }
    }

    @Override
    public Item getItem() {
        return this.item;
    }
}

