/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.remote.drawer;

import dev.xkmc.l2backpack.content.remote.common.DrawerAccess;
import dev.xkmc.l2backpack.init.advancement.BackpackTriggers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public record EnderDawerItemHandler(DrawerAccess access, boolean logistics) implements IItemHandler
{
    public int getSlots() {
        return 2;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        if (slot == 1) {
            return ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)this.access.item(), this.access.getCount());
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (stack.m_41782_() || stack.m_41720_() != this.access.item()) {
            return stack;
        }
        int count = this.access.getCount();
        int max = this.access.item().m_41459_() * 64;
        int insert = Math.min(max - count, stack.m_41613_());
        if (!simulate) {
            this.access.setCount(count + insert);
            if (this.logistics && insert > 0) {
                this.access.getOwner().ifPresent(BackpackTriggers.REMOTE::trigger);
            }
        }
        return insert == stack.m_41613_() ? ItemStack.f_41583_ : new ItemStack((ItemLike)this.access.item(), stack.m_41613_() - insert);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        int count = this.access.getCount();
        int take = Math.min(count, amount);
        if (!simulate) {
            this.access.setCount(count - take);
            if (this.logistics && take > 0) {
                this.access.getOwner().ifPresent(BackpackTriggers.REMOTE::trigger);
            }
        }
        return new ItemStack((ItemLike)this.access.item(), take);
    }

    public int getSlotLimit(int slot) {
        return 4096;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return !stack.m_41782_() && stack.m_41720_() == this.access.item();
    }
}

