/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.drawer;

import dev.xkmc.l2backpack.content.common.BaseItemRenderer;
import dev.xkmc.l2backpack.content.common.ContentTransfer;
import dev.xkmc.l2backpack.content.drawer.BaseDrawerItem;
import dev.xkmc.l2backpack.init.data.LangData;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.Nullable;

public class DrawerItem
extends BlockItem
implements BaseDrawerItem,
ContentTransfer.Quad {
    private static final String COUNT = "drawerCount";
    private static final int MAX = 64;

    public static int getCount(ItemStack drawer) {
        return Optional.ofNullable(drawer.m_41783_()).map(e -> e.m_128451_(COUNT)).orElse(0);
    }

    public static void setCount(ItemStack drawer, int count) {
        drawer.m_41784_().m_128405_(COUNT, count);
    }

    public DrawerItem(Block block, Item.Properties properties) {
        super(block, properties.m_41487_(1).m_41486_());
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(BaseItemRenderer.EXTENSIONS);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (world.m_5776_()) {
            ContentTransfer.playDrawerSound(player);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        if (!player.m_6144_()) {
            Item item = BaseDrawerItem.getItem(stack);
            int count = DrawerItem.getCount(stack);
            int max = Math.min(item.m_41459_(), count);
            player.m_150109_().m_150079_(new ItemStack((ItemLike)item, max));
            DrawerItem.setCount(stack, count - max);
            ContentTransfer.onExtract(player, max, stack);
        } else {
            boolean perform;
            Item item = BaseDrawerItem.getItem(stack);
            int count = DrawerItem.getCount(stack);
            int max = item.m_41459_() * 64;
            boolean bl = perform = !this.canSetNewItem(stack);
            if (!perform && (item = ContentTransfer.filterMaxItem((IItemHandler)new InvWrapper((Container)player.m_150109_()))) != Items.f_41852_) {
                perform = true;
                this.setItem(stack, item, player);
            }
            if (perform) {
                int ext = BaseDrawerItem.loadFromInventory(max, count, item, player);
                DrawerItem.setCount(stack, count += ext);
                ContentTransfer.onCollect(player, ext, stack);
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        InteractionResult result = ContentTransfer.blockInteract(context, this);
        if (result == InteractionResult.PASS && context.m_43723_() != null && context.m_43723_().m_6144_() && (result = super.m_6225_(context)) == InteractionResult.FAIL) {
            result = InteractionResult.PASS;
        }
        return result;
    }

    @Override
    public void click(Player player, ItemStack stack, boolean client, boolean shift, boolean right, @Nullable IItemHandler target) {
        Item item;
        if (!client && shift && right && target != null) {
            item = BaseDrawerItem.getItem(stack);
            int count = DrawerItem.getCount(stack);
            int remain = ContentTransfer.transfer(item, count, target);
            ContentTransfer.onDump(player, count - remain, stack);
            DrawerItem.setCount(stack, remain);
        } else if (client && shift && right && target != null) {
            ContentTransfer.playDrawerSound(player);
        }
        if (!client && shift && !right && target != null) {
            boolean perform;
            item = BaseDrawerItem.getItem(stack);
            boolean bl = perform = !this.canSetNewItem(stack);
            if (!perform && (item = ContentTransfer.filterMaxItem(target)) != Items.f_41852_) {
                this.setItem(stack, item, player);
                perform = true;
            }
            if (perform) {
                int count = DrawerItem.getCount(stack);
                int max = 64 * item.m_41459_();
                int remain = ContentTransfer.loadFrom(item, max - count, target);
                ContentTransfer.onLoad(player, remain, stack);
                DrawerItem.setCount(stack, count + remain);
            }
        } else if (client && shift && !right && target != null) {
            ContentTransfer.playDrawerSound(player);
        }
    }

    @Override
    public void insert(ItemStack drawer, ItemStack stack, Player player) {
        int count = DrawerItem.getCount(drawer);
        int allow = Math.min(64 * stack.m_41741_() - count, stack.m_41613_());
        DrawerItem.setCount(drawer, count + allow);
        stack.m_41774_(allow);
    }

    @Override
    public ItemStack takeItem(ItemStack drawer, Player player) {
        if (this.canSetNewItem(drawer)) {
            return ItemStack.f_41583_;
        }
        Item item = BaseDrawerItem.getItem(drawer);
        int count = DrawerItem.getCount(drawer);
        int take = Math.min(count, item.m_41459_());
        DrawerItem.setCount(drawer, count - take);
        return new ItemStack((ItemLike)item, take);
    }

    @Override
    public boolean canSetNewItem(ItemStack drawer) {
        return BaseDrawerItem.getItem(drawer) == Items.f_41852_ || DrawerItem.getCount(drawer) == 0;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        Item item = BaseDrawerItem.getItem(stack);
        int count = DrawerItem.getCount(stack);
        if (!this.canSetNewItem(stack)) {
            list.add((Component)LangData.IDS.DRAWER_CONTENT.get(item.m_41466_(), count));
        }
        LangData.addInfo(list, LangData.Info.DRAWER_USE, LangData.Info.DUMP, LangData.Info.LOAD, LangData.Info.PLACE, LangData.Info.EXTRACT_DRAWER, LangData.Info.COLLECT_DRAWER);
    }

    public String m_5524_() {
        return this.m_41467_();
    }
}

