/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.drawer;

import dev.xkmc.l2backpack.content.drawer.DrawerBlockEntity;
import dev.xkmc.l2library.serial.SerialClass;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

@SerialClass
public class DrawerHandler
implements IItemHandler {
    @SerialClass.SerialField(toClient=true)
    public Item item;
    @SerialClass.SerialField(toClient=true)
    public int count;
    private final DrawerBlockEntity parent;

    public DrawerHandler(DrawerBlockEntity parent) {
        this.parent = parent;
    }

    public int getSlots() {
        return 1;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return new ItemStack((ItemLike)this.item, this.count);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (stack.m_41782_()) {
            return stack;
        }
        int max = 64 * stack.m_41741_();
        if (this.count >= max) {
            return ItemStack.f_41583_;
        }
        if (this.item == Items.f_41852_) {
            int toInsert = Math.min(max, stack.m_41613_());
            if (!simulate) {
                this.item = stack.m_41720_();
                this.count = toInsert;
                this.parent.sync();
            }
            if (toInsert == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            ItemStack ans = stack.m_41777_();
            ans.m_41764_(stack.m_41613_() - toInsert);
            return ans;
        }
        if (this.item != stack.m_41720_()) {
            return stack;
        }
        int toInsert = Math.min(max - this.count, stack.m_41613_());
        if (!simulate) {
            this.item = stack.m_41720_();
            this.count += toInsert;
            this.parent.sync();
        }
        if (toInsert == stack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        ItemStack ans = stack.m_41777_();
        ans.m_41764_(stack.m_41613_() - toInsert);
        return ans;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.item == Items.f_41852_ || this.count == 0) {
            return ItemStack.f_41583_;
        }
        int toExtract = Math.min(amount, this.count);
        ItemStack ans = new ItemStack((ItemLike)this.item, toExtract);
        if (!simulate) {
            this.count -= toExtract;
            if (this.count == 0) {
                this.item = Items.f_41852_;
            }
            this.parent.sync();
        }
        return ans;
    }

    public int getSlotLimit(int slot) {
        return 4096;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return stack.m_41783_() == null && (this.item == Items.f_41852_ || stack.m_41720_() == this.item);
    }
}

