/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.common;

import dev.xkmc.l2backpack.compat.CuriosCompat;
import dev.xkmc.l2backpack.content.common.ContainerType;
import dev.xkmc.l2backpack.content.quickswap.merged.EnderSwitchContainer;
import dev.xkmc.l2backpack.content.remote.worldchest.WorldChestContainer;
import dev.xkmc.l2backpack.events.ClientEventHandler;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.ItemStack;

public record PlayerSlot(ContainerType type, int slot, UUID uuid) {
    public static PlayerSlot ofInventory(int slot) {
        return new PlayerSlot(ContainerType.INVENTORY, slot, Util.f_137441_);
    }

    @Nullable
    public static PlayerSlot ofOtherInventory(int slot, int index, int wid, AbstractContainerMenu menu) {
        ChestMenu chest;
        if (menu instanceof ChestMenu && (chest = (ChestMenu)menu).m_39261_() instanceof PlayerEnderChestContainer) {
            return new PlayerSlot(ContainerType.ENDER, index, Util.f_137441_);
        }
        if (menu instanceof EnderSwitchContainer && index >= 36 && index < 63) {
            return new PlayerSlot(ContainerType.ENDER, index - 36, Util.f_137441_);
        }
        if (menu instanceof WorldChestContainer) {
            WorldChestContainer cont = (WorldChestContainer)menu;
            return new PlayerSlot(ContainerType.DIMENSION, cont.getColor() * 27 + index - 36, cont.getOwner());
        }
        return CuriosCompat.getPlayerSlot(slot, index, wid, menu).map(e -> new PlayerSlot(ContainerType.CURIO, (int)e, Util.f_137441_)).orElse(null);
    }

    public static PlayerSlot read(FriendlyByteBuf buf) {
        ContainerType type = ContainerType.values()[buf.readInt()];
        int slot = buf.readInt();
        UUID id = buf.m_130259_();
        return new PlayerSlot(type, slot, id);
    }

    @Nullable
    public static PlayerSlot ofCurio(Player player) {
        return CuriosCompat.getSearchBag(player, ClientEventHandler::canOpen).map(e -> new PlayerSlot(ContainerType.CURIO, (int)e, Util.f_137441_)).orElse(null);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.type.ordinal());
        buf.writeInt(this.slot);
        buf.m_130077_(this.uuid);
    }

    public ItemStack getItem(Player player) {
        return this.type.getItem(player, this);
    }
}

