/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.common;

import dev.xkmc.l2backpack.content.common.BaseBagContainer;
import dev.xkmc.l2backpack.content.common.BaseOpenableScreen;
import dev.xkmc.l2backpack.content.common.ContentTransfer;
import dev.xkmc.l2backpack.content.common.PlayerSlot;
import dev.xkmc.l2backpack.content.quickswap.quiver.Quiver;
import dev.xkmc.l2library.util.Proxy;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public abstract class BaseBagItem
extends Item
implements ContentTransfer.Quad {
    public static ListTag getListTag(ItemStack stack) {
        if (stack.m_41784_().m_128441_("Items")) {
            return stack.m_41784_().m_128437_("Items", 10);
        }
        return new ListTag();
    }

    public static void setListTag(ItemStack stack, ListTag list) {
        stack.m_41784_().m_128365_("Items", (Tag)list);
    }

    public static long getTimeStamp(ItemStack stack) {
        return stack.m_41784_().m_128454_("TimeStamp");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float isOpened(ItemStack stack, ClientLevel level, LivingEntity entity, int i) {
        BaseOpenableScreen gui;
        AbstractContainerMenu abstractContainerMenu;
        if (entity != Proxy.getClientPlayer()) {
            return 0.0f;
        }
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof BaseOpenableScreen && (abstractContainerMenu = (gui = (BaseOpenableScreen)screen).m_6262_()) instanceof BaseBagContainer) {
            BaseBagContainer cont = (BaseBagContainer)abstractContainerMenu;
            return cont.getStack() == stack ? 1.0f : 0.0f;
        }
        return 0.0f;
    }

    public BaseBagItem(Item.Properties props) {
        super(props);
    }

    public static List<ItemStack> getItems(ItemStack stack) {
        ArrayList<ItemStack> ans = new ArrayList<ItemStack>();
        ListTag tag = BaseBagItem.getListTag(stack);
        for (Tag value : tag) {
            ans.add(ItemStack.m_41712_((CompoundTag)((CompoundTag)value)));
        }
        return ans;
    }

    public static void setItems(ItemStack stack, List<ItemStack> list) {
        ListTag tag = new ListTag();
        for (int i = 0; i < list.size(); ++i) {
            tag.add(i, (Tag)list.get(i).m_41739_(new CompoundTag()));
        }
        Quiver.setListTag(stack, tag);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.m_5776_()) {
            int slot = hand == InteractionHand.MAIN_HAND ? player.m_150109_().f_35977_ : 40;
            this.open((ServerPlayer)player, PlayerSlot.ofInventory(slot), stack);
        } else {
            ContentTransfer.playSound(player);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        return ContentTransfer.blockInteract(context, this);
    }

    @Override
    public void click(Player player, ItemStack stack, boolean client, boolean shift, boolean right, @Nullable IItemHandler target) {
        int moved;
        List<ItemStack> list;
        if (!client && shift && right && target != null) {
            list = BaseBagItem.getItems(stack);
            moved = ContentTransfer.transfer(list, target);
            BaseBagItem.setItems(stack, list);
            ContentTransfer.onDump(player, moved, stack);
        } else if (client && shift && right && target != null) {
            ContentTransfer.playSound(player);
        }
        if (!client && shift && !right && target != null) {
            list = BaseBagItem.getItems(stack);
            moved = ContentTransfer.loadFrom(list, target, player, this::isValidContent);
            BaseBagItem.setItems(stack, list);
            ContentTransfer.onLoad(player, moved, stack);
        } else if (client && shift && !right && target != null) {
            ContentTransfer.playSound(player);
        }
    }

    public boolean isValidContent(ItemStack stack) {
        return stack.m_41720_().m_142095_();
    }

    public abstract void open(ServerPlayer var1, PlayerSlot var2, ItemStack var3);

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, Entity entity) {
        return armorType == EquipmentSlot.CHEST;
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.CHEST;
    }
}

