/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.content.common;

import dev.xkmc.l2backpack.content.common.BaseBagItem;
import dev.xkmc.l2backpack.content.common.BaseOpenableContainer;
import dev.xkmc.l2backpack.content.common.PlayerSlot;
import dev.xkmc.l2backpack.content.restore.ScreenTracker;
import dev.xkmc.l2library.base.menu.BaseContainerMenu;
import dev.xkmc.l2library.base.menu.SpriteManager;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;

public abstract class BaseBagContainer<T extends BaseBagContainer<T>>
extends BaseOpenableContainer<T> {
    private static final ConcurrentHashMap<UUID, ConcurrentLinkedQueue<BaseBagContainer<?>>> MAP = new ConcurrentHashMap();
    protected final PlayerSlot item_slot;
    protected final UUID uuid;
    private ItemStack stack_cache = ItemStack.f_41583_;

    public BaseBagContainer(MenuType<T> type, int windowId, Inventory inventory, SpriteManager manager, PlayerSlot hand, UUID uuid, int row, Predicate<ItemStack> pred, @Nullable Component title) {
        super(type, windowId, inventory, manager, menu -> new BaseContainerMenu.BaseContainer(row * 9, (BaseContainerMenu)menu), title);
        this.item_slot = hand;
        this.uuid = uuid;
        this.addSlot("grid", pred);
        if (!this.player.f_19853_.m_5776_()) {
            MAP.computeIfAbsent(uuid, e -> new ConcurrentLinkedQueue()).add(this);
            this.reload();
        }
    }

    private void reload() {
        ItemStack stack = this.getStack();
        if (!stack.m_41619_()) {
            ListTag tag = BaseBagItem.getListTag(stack);
            for (int i = 0; i < tag.size(); ++i) {
                this.container.m_6836_(i, ItemStack.m_41712_((CompoundTag)((CompoundTag)tag.get(i))));
            }
        }
    }

    public void m_6199_(Container cont) {
        this.save();
    }

    public void m_6877_(Player player) {
        if (!player.f_19853_.f_46443_) {
            MAP.computeIfAbsent(this.uuid, e -> new ConcurrentLinkedQueue()).remove((Object)this);
            this.save();
            ScreenTracker.onServerClose(player, this.f_38840_);
        }
        super.m_6877_(player);
    }

    private void save() {
        if (this.player.m_9236_().m_5776_()) {
            return;
        }
        ItemStack stack = this.getStack();
        if (!stack.m_41619_()) {
            this.serializeContents(stack);
        }
        MAP.computeIfAbsent(this.uuid, e -> new ConcurrentLinkedQueue()).forEach(BaseBagContainer::reload);
    }

    protected void serializeContents(ItemStack stack) {
        ListTag list = new ListTag();
        for (int i = 0; i < this.container.m_6643_(); ++i) {
            list.add(i, (Tag)this.container.m_8020_(i).m_41739_(new CompoundTag()));
        }
        BaseBagItem.setListTag(stack, list);
    }

    public boolean m_6875_(Player player) {
        ItemStack oldStack = this.stack_cache;
        ItemStack newStack = this.getStackRaw();
        return !this.getStackRaw().m_41619_() && oldStack == newStack;
    }

    public ItemStack getStack() {
        ItemStack stack = this.getStackRaw();
        if (stack.m_41619_()) {
            return this.stack_cache;
        }
        return stack;
    }

    private ItemStack getStackRaw() {
        ItemStack stack = this.item_slot.getItem(this.player);
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return ItemStack.f_41583_;
        }
        if (!tag.m_128441_("container_id")) {
            return ItemStack.f_41583_;
        }
        if (!tag.m_128342_("container_id").equals(this.uuid)) {
            return ItemStack.f_41583_;
        }
        this.stack_cache = stack;
        return stack;
    }
}

