/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.compat;

import dev.xkmc.l2backpack.content.common.BaseBagItem;
import dev.xkmc.l2backpack.content.remote.common.StorageContainer;
import dev.xkmc.l2backpack.content.remote.worldchest.WorldChestInvWrapper;
import dev.xkmc.l2backpack.content.remote.worldchest.WorldChestItem;
import dev.xkmc.l2backpack.init.registrate.BackpackBlocks;
import dev.xkmc.l2library.repack.registrate.providers.RegistrateTagsProvider;
import dev.xkmc.l2library.util.code.GenericItemStack;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.events.event.GolemEquipEvent;
import dev.xkmc.modulargolems.events.event.GolemHandleItemEvent;
import dev.xkmc.modulargolems.init.data.TagGen;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class GolemCompat {
    public static void register() {
        MinecraftForge.EVENT_BUS.register(GolemCompat.class);
    }

    private static boolean canEquip(ItemStack stack) {
        if (stack.m_41720_() instanceof BaseBagItem) {
            return true;
        }
        if (stack.m_41720_() instanceof WorldChestItem) {
            return stack.m_41782_() && stack.m_41784_().m_128441_("owner_id");
        }
        return false;
    }

    @Nullable
    private static GenericItemStack<WorldChestItem> getBackpack(AbstractGolemEntity<?, ?> golem) {
        for (EquipmentSlot e : List.of(EquipmentSlot.CHEST, EquipmentSlot.OFFHAND)) {
            ItemStack stack = golem.m_6844_(e);
            Item item = stack.m_41720_();
            if (!(item instanceof WorldChestItem)) continue;
            WorldChestItem item2 = (WorldChestItem)item;
            return new GenericItemStack((Item)item2, stack);
        }
        return null;
    }

    @SubscribeEvent
    public static void onEquip(GolemEquipEvent event) {
        if (GolemCompat.canEquip(event.getStack())) {
            ItemStack back = event.getEntity().m_6844_(EquipmentSlot.CHEST);
            if (back.m_41619_() || GolemCompat.canEquip(back)) {
                event.setSlot(EquipmentSlot.CHEST, 1);
            } else {
                event.setSlot(EquipmentSlot.OFFHAND, 1);
            }
        }
    }

    @SubscribeEvent
    public static void onHandleItem(GolemHandleItemEvent event) {
        if (event.getItem().m_213877_()) {
            return;
        }
        ItemStack stack = event.getItem().m_32055_();
        if (stack.m_41619_()) {
            return;
        }
        GenericItemStack<WorldChestItem> backpack = GolemCompat.getBackpack(event.getEntity());
        if (backpack == null) {
            return;
        }
        ServerLevel level = (ServerLevel)event.getEntity().f_19853_;
        Optional<StorageContainer> cont = ((WorldChestItem)backpack.item()).getContainer(backpack.stack(), level);
        if (cont.isEmpty()) {
            return;
        }
        StorageContainer storage = cont.get();
        WorldChestInvWrapper handler = new WorldChestInvWrapper((Container)storage.container, storage.id);
        ItemStack remain = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false);
        event.getItem().m_32045_(remain);
    }

    public static void genBlockTag(RegistrateTagsProvider<Block> pvd) {
        pvd.m_206424_(TagGen.POTENTIAL_DST).m_126582_((Object)((Block)BackpackBlocks.WORLD_CHEST.get()));
    }
}

