/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2backpack.compat;

import dev.xkmc.l2backpack.content.common.PlayerSlot;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.network.NetworkHooks;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.common.inventory.CurioSlot;
import top.theillusivec4.curios.common.inventory.container.CuriosContainer;
import top.theillusivec4.curios.common.inventory.container.CuriosContainerProvider;

public class CuriosCompat {
    public static void init() {
        if (ModList.get().isLoaded("curios")) {
            CuriosCompat.initImpl();
        }
    }

    public static ItemStack getSlot(Player player, Predicate<ItemStack> pred) {
        if (ModList.get().isLoaded("curios")) {
            return CuriosCompat.getSlotImpl(player, pred);
        }
        return ItemStack.f_41583_;
    }

    public static Optional<Integer> getPlayerSlot(int slot, int index, int wid, AbstractContainerMenu menu) {
        if (ModList.get().isLoaded("curios")) {
            return CuriosCompat.getPlayerSlotImpl(slot, index, wid, menu);
        }
        return Optional.empty();
    }

    public static ItemStack getItemFromSlot(Player player, PlayerSlot slot) {
        if (ModList.get().isLoaded("curios")) {
            return CuriosCompat.getItemFromSlotImpl(player, slot.slot());
        }
        return ItemStack.f_41583_;
    }

    public static Optional<Integer> getSearchBag(Player player, Predicate<ItemStack> pred) {
        if (ModList.get().isLoaded("curios")) {
            return CuriosCompat.getSearchBagImpl(player, pred);
        }
        return Optional.empty();
    }

    public static boolean openCurio(ServerPlayer player) {
        if (ModList.get().isLoaded("curios")) {
            CuriosCompat.openCurioImpl(player);
            return true;
        }
        return false;
    }

    private static void initImpl() {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BACK.getMessageBuilder().build());
    }

    private static ItemStack getSlotImpl(Player player, Predicate<ItemStack> pred) {
        LazyOptional curio = CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)player);
        if (curio.isPresent() && curio.resolve().isPresent()) {
            IItemHandlerModifiable e = (IItemHandlerModifiable)curio.resolve().get();
            for (int i = 0; i < e.getSlots(); ++i) {
                ItemStack stack = e.getStackInSlot(i);
                if (!pred.test(stack)) continue;
                return stack;
            }
        }
        return ItemStack.f_41583_;
    }

    private static Optional<Integer> getPlayerSlotImpl(int slot, int index, int wid, AbstractContainerMenu menu) {
        CuriosContainer cont;
        Slot s;
        if (menu.f_38840_ == wid && menu instanceof CuriosContainer && (s = (cont = (CuriosContainer)menu).m_38853_(index)) instanceof CurioSlot) {
            CurioSlot curioSlot = (CurioSlot)s;
            int slotIndex = CuriosCompat.getSlotIndexInContainer(cont.player, curioSlot.getIdentifier());
            if (slotIndex < 0) {
                return Optional.empty();
            }
            int val = slotIndex + curioSlot.getSlotIndex();
            return Optional.of(val);
        }
        return Optional.empty();
    }

    private static ItemStack getItemFromSlotImpl(Player player, int slot) {
        LazyOptional curios = CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)player);
        if (curios.isPresent() && curios.resolve().isPresent()) {
            IItemHandlerModifiable e = (IItemHandlerModifiable)curios.resolve().get();
            return e.getStackInSlot(slot);
        }
        return ItemStack.f_41583_;
    }

    private static int getSlotIndexInContainer(Player player, String id) {
        LazyOptional curiosLazy = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player);
        if (!curiosLazy.isPresent() || !curiosLazy.resolve().isPresent()) {
            return -1;
        }
        Map curios = ((ICuriosItemHandler)curiosLazy.resolve().get()).getCurios();
        int index = 0;
        for (ICurioStacksHandler stacksHandler : curios.values()) {
            if (stacksHandler.getIdentifier().equals(id)) {
                return index;
            }
            index += stacksHandler.getSlots();
        }
        return -1;
    }

    private static Optional<Integer> getSearchBagImpl(Player player, Predicate<ItemStack> pred) {
        LazyOptional curio = CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)player);
        if (curio.isPresent() && curio.resolve().isPresent()) {
            IItemHandlerModifiable e = (IItemHandlerModifiable)curio.resolve().get();
            for (int i = 0; i < e.getSlots(); ++i) {
                ItemStack stack = e.getStackInSlot(i);
                if (!pred.test(stack)) continue;
                return Optional.of(i);
            }
        }
        return Optional.empty();
    }

    private static void openCurioImpl(ServerPlayer player) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new CuriosContainerProvider());
    }
}

