/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.google.gson.JsonPrimitive;
import dev.latvian.mods.kubejs.block.state.BlockStatePredicate;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.ReplacementMatch;
import dev.latvian.mods.kubejs.recipe.component.ComponentRole;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.util.UtilsJS;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public record BlockStateComponent(ComponentRole crole) implements RecipeComponent<BlockState>
{
    public static final RecipeComponent<BlockState> INPUT = new BlockStateComponent(ComponentRole.INPUT);
    public static final RecipeComponent<BlockState> OUTPUT = new BlockStateComponent(ComponentRole.OUTPUT);
    public static final RecipeComponent<BlockState> BLOCK = new BlockStateComponent(ComponentRole.OTHER);

    @Override
    public ComponentRole role() {
        return this.crole;
    }

    @Override
    public String componentType() {
        return "block_state";
    }

    @Override
    public Class<?> componentClass() {
        return BlockState.class;
    }

    public JsonPrimitive write(RecipeJS recipe, BlockState value) {
        return new JsonPrimitive(BlockStateParser.m_116769_((BlockState)value));
    }

    @Override
    public BlockState read(RecipeJS recipe, Object from) {
        if (from instanceof BlockState) {
            BlockState s = (BlockState)from;
            return s;
        }
        if (from instanceof Block) {
            Block b = (Block)from;
            return b.m_49966_();
        }
        if (from instanceof JsonPrimitive) {
            JsonPrimitive json = (JsonPrimitive)from;
            return UtilsJS.parseBlockState(json.getAsString());
        }
        return UtilsJS.parseBlockState(String.valueOf(from));
    }

    @Override
    public boolean isInput(RecipeJS recipe, BlockState value, ReplacementMatch match) {
        BlockStatePredicate m2;
        return this.crole.isInput() && match instanceof BlockStatePredicate && (m2 = (BlockStatePredicate)match).test(value);
    }

    @Override
    public boolean isOutput(RecipeJS recipe, BlockState value, ReplacementMatch match) {
        BlockStatePredicate m2;
        return this.crole.isOutput() && match instanceof BlockStatePredicate && (m2 = (BlockStatePredicate)match).test(value);
    }

    @Override
    public String checkEmpty(RecipeKey<BlockState> key, BlockState value) {
        if (value.m_60734_() == Blocks.f_50016_) {
            return "Block '" + key.name + "' can't be empty!";
        }
        return "";
    }

    @Override
    public String toString() {
        return this.componentType();
    }
}

