/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.gui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.konkrete.config.Config;
import de.keksuccino.konkrete.config.ConfigEntry;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.gui.content.AdvancedTextField;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollArea;
import de.keksuccino.konkrete.gui.content.scrollarea.ScrollAreaEntry;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ConfigScreen
extends Screen {
    protected Config config;
    protected ScrollArea configList;
    protected Screen parent;
    protected String f_96539_;
    protected AdvancedButton doneBtn;
    protected String activeDescription = null;
    protected Map<String, String> descriptions = new HashMap<String, String>();
    protected static final Color ENTRY_BACKGROUND_COLOR = new Color(92, 92, 92);
    protected static final Color SCREEN_BACKGROUND_COLOR = new Color(54, 54, 54);
    protected static final Color HEADER_FOOTER_COLOR = new Color(33, 33, 33);

    public ConfigScreen(Config config, String title, Screen parent) {
        super((Component)Component.m_237113_((String)""));
        this.config = config;
        this.parent = parent;
        this.f_96539_ = title;
        this.configList = new ScrollArea(0, 50, 300, 0);
        this.configList.backgroundColor = ENTRY_BACKGROUND_COLOR;
        for (String s : this.config.getCategorys()) {
            this.configList.addEntry(new CategoryConfigScrollAreaEntry(this.configList, s));
            for (ConfigEntry e : this.config.getEntrysForCategory(s)) {
                if (e.getType() == ConfigEntry.EntryType.STRING) {
                    this.configList.addEntry(new StringConfigScrollAreaEntry(this.configList, e));
                }
                if (e.getType() == ConfigEntry.EntryType.INTEGER) {
                    this.configList.addEntry(new IntegerConfigScrollAreaEntry(this.configList, e));
                }
                if (e.getType() == ConfigEntry.EntryType.DOUBLE) {
                    this.configList.addEntry(new DoubleConfigScrollAreaEntry(this.configList, e));
                }
                if (e.getType() == ConfigEntry.EntryType.FLOAT) {
                    this.configList.addEntry(new FloatConfigScrollAreaEntry(this.configList, e));
                }
                if (e.getType() == ConfigEntry.EntryType.LONG) {
                    this.configList.addEntry(new LongConfigScrollAreaEntry(this.configList, e));
                }
                if (e.getType() != ConfigEntry.EntryType.BOOLEAN) continue;
                this.configList.addEntry(new BooleanConfigScrollAreaEntry(this.configList, e));
            }
        }
        this.doneBtn = new AdvancedButton(0, 0, 100, 20, Locals.localize("popup.done", new String[0]), true, press -> Minecraft.m_91087_().m_91152_(this.parent));
        ConfigScreen.colorizeButton(this.doneBtn);
        this.doneBtn.ignoreBlockedInput = true;
        this.doneBtn.ignoreLeftMouseDownClickBlock = true;
    }

    protected void m_7856_() {
        this.configList.x = this.f_96543_ / 2 - 150;
        this.configList.height = this.f_96544_ - 100;
    }

    public void m_7861_() {
        this.saveConfig();
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.parent);
    }

    public boolean m_6913_() {
        return true;
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_69478_();
        ConfigScreen.m_93172_((PoseStack)matrix, (int)0, (int)0, (int)this.f_96543_, (int)this.f_96544_, (int)SCREEN_BACKGROUND_COLOR.getRGB());
        this.configList.render(matrix);
        ConfigScreen.m_93172_((PoseStack)matrix, (int)0, (int)0, (int)this.f_96543_, (int)50, (int)HEADER_FOOTER_COLOR.getRGB());
        if (this.f_96539_ != null) {
            ConfigScreen.m_93236_((PoseStack)matrix, (Font)this.f_96547_, (String)this.f_96539_, (int)(this.f_96543_ / 2 - this.f_96547_.m_92895_(this.f_96539_) / 2), (int)20, (int)Color.WHITE.getRGB());
        }
        ConfigScreen.m_93172_((PoseStack)matrix, (int)0, (int)(this.f_96544_ - 50), (int)this.f_96543_, (int)this.f_96544_, (int)HEADER_FOOTER_COLOR.getRGB());
        this.doneBtn.setX(this.f_96543_ / 2 - this.doneBtn.m_5711_() / 2);
        this.doneBtn.setY(this.f_96544_ - 35);
        this.doneBtn.m_6305_(matrix, mouseX, mouseY, partialTicks);
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
        for (ScrollAreaEntry e : this.configList.getEntries()) {
            String name;
            if (!(e instanceof ConfigScrollAreaEntry) || !e.isHoveredOrFocused() || !this.descriptions.containsKey(name = ((ConfigScrollAreaEntry)e).configEntry.getName())) continue;
            if (ConfigScrollAreaEntry.isHeaderFooterHovered()) break;
            ConfigScreen.renderDescription(matrix, this.descriptions.get(name), mouseX, mouseY);
            break;
        }
    }

    public void setValueDescription(String valueName, String desc) {
        this.descriptions.put(valueName, desc);
    }

    public void setCategoryDisplayName(String categoryName, String displayName) {
        CategoryConfigScrollAreaEntry e = this.getCategoryEntryByName(categoryName);
        if (e != null) {
            e.displayName = displayName;
        }
    }

    public void setValueDisplayName(String valueName, String displayName) {
        ConfigScrollAreaEntry e = this.getEntryByValueName(valueName);
        if (e != null) {
            e.displayName = displayName;
        }
    }

    protected ConfigScrollAreaEntry getEntryByValueName(String valueName) {
        for (ScrollAreaEntry e : this.configList.getEntries()) {
            if (!(e instanceof ConfigScrollAreaEntry) || !((ConfigScrollAreaEntry)e).configEntry.getName().equals(valueName)) continue;
            return (ConfigScrollAreaEntry)e;
        }
        return null;
    }

    protected CategoryConfigScrollAreaEntry getCategoryEntryByName(String categoryName) {
        for (ScrollAreaEntry e : this.configList.getEntries()) {
            if (!(e instanceof CategoryConfigScrollAreaEntry) || !((CategoryConfigScrollAreaEntry)e).category.equals(categoryName)) continue;
            return (CategoryConfigScrollAreaEntry)e;
        }
        return null;
    }

    protected void saveConfig() {
        for (ScrollAreaEntry e : this.configList.getEntries()) {
            if (!(e instanceof ConfigScrollAreaEntry)) continue;
            ((ConfigScrollAreaEntry)e).onSave();
        }
        this.config.syncConfig();
    }

    protected static void renderDescription(PoseStack matrix, String description, int mouseX, int mouseY) {
        if (description != null) {
            String[] desc;
            int width = 10;
            int height = 10;
            for (String s : desc = StringUtils.splitLines(description, "%n%")) {
                int i = Minecraft.m_91087_().f_91062_.m_92895_(s) + 10;
                if (i > width) {
                    width = i;
                }
                height += 10;
            }
            mouseY += 5;
            if (Minecraft.m_91087_().f_91080_.f_96543_ < (mouseX += 5) + width) {
                mouseX -= width + 10;
            }
            if (Minecraft.m_91087_().f_91080_.f_96544_ < mouseY + height) {
                mouseY -= height + 10;
            }
            RenderUtils.setZLevelPre(matrix, 600);
            ConfigScreen.renderDescriptionBackground(matrix, mouseX, mouseY, width, height);
            RenderSystem.m_69478_();
            int i2 = 5;
            for (String s : desc) {
                ConfigScreen.m_93236_((PoseStack)matrix, (Font)Minecraft.m_91087_().f_91062_, (String)s, (int)(mouseX + 5), (int)(mouseY + i2), (int)Color.WHITE.getRGB());
                i2 += 10;
            }
            RenderUtils.setZLevelPost(matrix);
            RenderSystem.m_69461_();
        }
    }

    protected static void renderDescriptionBackground(PoseStack matrix, int x, int y, int width, int height) {
        ConfigScreen.m_93172_((PoseStack)matrix, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)new Color(26, 26, 26, 250).getRGB());
    }

    protected static void colorizeButton(AdvancedButton b) {
        b.setBackgroundColor(new Color(100, 100, 100), new Color(130, 130, 130), new Color(180, 180, 180), new Color(199, 199, 199), 1);
    }

    protected static class CategoryConfigScrollAreaEntry
    extends ScrollAreaEntry {
        protected String category;
        protected Font font;
        protected String displayName;

        public CategoryConfigScrollAreaEntry(ScrollArea parent, String category) {
            super(parent);
            this.font = Minecraft.m_91087_().f_91062_;
            this.category = category;
        }

        @Override
        public void renderEntry(PoseStack matrix) {
            int center = this.x + this.getWidth() / 2;
            CategoryConfigScrollAreaEntry.m_93172_((PoseStack)matrix, (int)this.x, (int)this.y, (int)(this.x + this.getWidth()), (int)(this.y + this.getHeight()), (int)ENTRY_BACKGROUND_COLOR.getRGB());
            if (this.displayName != null) {
                int nameWidth = this.font.m_92895_(this.displayName);
                CategoryConfigScrollAreaEntry.m_93236_((PoseStack)matrix, (Font)this.font, (String)this.displayName, (int)(center - nameWidth / 2), (int)(this.y + 10), (int)Color.WHITE.getRGB());
            } else {
                int nameWidth = this.font.m_92895_(this.category);
                CategoryConfigScrollAreaEntry.m_93236_((PoseStack)matrix, (Font)this.font, (String)this.category, (int)(center - nameWidth / 2), (int)(this.y + 10), (int)Color.WHITE.getRGB());
            }
        }

        @Override
        public int getHeight() {
            return 30;
        }
    }

    protected static class StringConfigScrollAreaEntry
    extends ConfigScrollAreaEntry {
        private AdvancedTextField input;

        public StringConfigScrollAreaEntry(ScrollArea parent, ConfigEntry configEntry) {
            super(parent, configEntry);
            this.input = new AdvancedTextField(this.font, 0, 0, 100, 20, true, null);
            this.input.m_94199_(10000);
            this.input.m_94144_(configEntry.getValue());
        }

        @Override
        public void render(PoseStack matrix) {
            super.render(matrix);
            int center = this.x + this.getWidth() / 2;
            this.input.m_94214_(center + 10);
            this.input.setY(this.y + 3);
            this.input.m_6305_(matrix, MouseInput.getMouseX(), MouseInput.getMouseY(), Minecraft.m_91087_().m_91296_());
        }

        @Override
        protected void onSave() {
            this.configEntry.setValue(this.input.m_94155_());
        }
    }

    protected static class IntegerConfigScrollAreaEntry
    extends ConfigScrollAreaEntry {
        private AdvancedTextField input;

        public IntegerConfigScrollAreaEntry(ScrollArea parent, ConfigEntry configEntry) {
            super(parent, configEntry);
            this.input = new AdvancedTextField(this.font, 0, 0, 100, 20, true, CharacterFilter.getIntegerCharacterFiler());
            this.input.m_94199_(10000);
            this.input.m_94144_(configEntry.getValue());
        }

        @Override
        public void render(PoseStack matrix) {
            super.render(matrix);
            int center = this.x + this.getWidth() / 2;
            this.input.m_94214_(center + 10);
            this.input.setY(this.y + 3);
            this.input.m_6305_(matrix, MouseInput.getMouseX(), MouseInput.getMouseY(), Minecraft.m_91087_().m_91296_());
        }

        @Override
        protected void onSave() {
            if (MathUtils.isInteger(this.input.m_94155_())) {
                this.configEntry.setValue(this.input.m_94155_());
            } else {
                System.out.println("################ ERROR [KONKRETE] ################");
                System.out.println("Unable to save value to config! Invalid value type!");
                System.out.println("Value: " + this.input.m_94155_());
                System.out.println("Variable Type: INTEGER");
                System.out.println("##################################################");
            }
        }
    }

    protected static class DoubleConfigScrollAreaEntry
    extends ConfigScrollAreaEntry {
        private AdvancedTextField input;

        public DoubleConfigScrollAreaEntry(ScrollArea parent, ConfigEntry configEntry) {
            super(parent, configEntry);
            this.input = new AdvancedTextField(this.font, 0, 0, 100, 20, true, CharacterFilter.getDoubleCharacterFiler());
            this.input.m_94199_(10000);
            this.input.m_94144_(configEntry.getValue());
        }

        @Override
        public void render(PoseStack matrix) {
            super.render(matrix);
            int center = this.x + this.getWidth() / 2;
            this.input.m_94214_(center + 10);
            this.input.setY(this.y + 3);
            this.input.m_6305_(matrix, MouseInput.getMouseX(), MouseInput.getMouseY(), Minecraft.m_91087_().m_91296_());
        }

        @Override
        protected void onSave() {
            if (MathUtils.isDouble(this.input.m_94155_())) {
                this.configEntry.setValue(this.input.m_94155_());
            } else {
                System.out.println("################ ERROR [KONKRETE] ################");
                System.out.println("Unable to save value to config! Invalid value type!");
                System.out.println("Value: " + this.input.m_94155_());
                System.out.println("Variable Type: DOUBLE");
                System.out.println("##################################################");
            }
        }
    }

    protected static class FloatConfigScrollAreaEntry
    extends ConfigScrollAreaEntry {
        private AdvancedTextField input;

        public FloatConfigScrollAreaEntry(ScrollArea parent, ConfigEntry configEntry) {
            super(parent, configEntry);
            this.input = new AdvancedTextField(this.font, 0, 0, 100, 20, true, CharacterFilter.getDoubleCharacterFiler());
            this.input.m_94199_(10000);
            this.input.m_94144_(configEntry.getValue());
        }

        @Override
        public void render(PoseStack matrix) {
            super.render(matrix);
            int center = this.x + this.getWidth() / 2;
            this.input.m_94214_(center + 10);
            this.input.setY(this.y + 3);
            this.input.m_6305_(matrix, MouseInput.getMouseX(), MouseInput.getMouseY(), Minecraft.m_91087_().m_91296_());
        }

        @Override
        protected void onSave() {
            if (MathUtils.isFloat(this.input.m_94155_())) {
                this.configEntry.setValue(this.input.m_94155_());
            } else {
                System.out.println("################ ERROR [KONKRETE] ################");
                System.out.println("Unable to save value to config! Invalid value type!");
                System.out.println("Value: " + this.input.m_94155_());
                System.out.println("Variable Type: FLOAT");
                System.out.println("##################################################");
            }
        }
    }

    protected static class LongConfigScrollAreaEntry
    extends ConfigScrollAreaEntry {
        private AdvancedTextField input;

        public LongConfigScrollAreaEntry(ScrollArea parent, ConfigEntry configEntry) {
            super(parent, configEntry);
            this.input = new AdvancedTextField(this.font, 0, 0, 100, 20, true, CharacterFilter.getIntegerCharacterFiler());
            this.input.m_94199_(10000);
            this.input.m_94144_(configEntry.getValue());
        }

        @Override
        public void render(PoseStack matrix) {
            super.render(matrix);
            int center = this.x + this.getWidth() / 2;
            this.input.m_94214_(center + 10);
            this.input.setY(this.y + 3);
            this.input.m_6305_(matrix, MouseInput.getMouseX(), MouseInput.getMouseY(), Minecraft.m_91087_().m_91296_());
        }

        @Override
        protected void onSave() {
            if (MathUtils.isLong(this.input.m_94155_())) {
                this.configEntry.setValue(this.input.m_94155_());
            } else {
                System.out.println("################ ERROR [KONKRETE] ################");
                System.out.println("Unable to save value to config! Invalid value type!");
                System.out.println("Value: " + this.input.m_94155_());
                System.out.println("Variable Type: LONG");
                System.out.println("##################################################");
            }
        }
    }

    protected static class BooleanConfigScrollAreaEntry
    extends ConfigScrollAreaEntry {
        private AdvancedButton toggleBtn;
        private boolean state = false;

        public BooleanConfigScrollAreaEntry(ScrollArea parent, ConfigEntry configEntry) {
            super(parent, configEntry);
            if (configEntry.getValue().equalsIgnoreCase("true")) {
                this.state = true;
            }
            this.toggleBtn = new AdvancedButton(0, 0, 102, 20, "", true, press -> {
                if (!BooleanConfigScrollAreaEntry.isHeaderFooterHovered()) {
                    boolean bl = this.state = !this.state;
                    if (this.state) {
                        this.toggleBtn.m_93666_((Component)Component.m_237113_((String)("\u00a7a" + Locals.localize("configscreen.boolean.enabled", new String[0]))));
                    } else {
                        this.toggleBtn.m_93666_((Component)Component.m_237113_((String)("\u00a7c" + Locals.localize("configscreen.boolean.disabled", new String[0]))));
                    }
                }
            });
            if (this.state) {
                this.toggleBtn.m_93666_((Component)Component.m_237113_((String)("\u00a7a" + Locals.localize("configscreen.boolean.enabled", new String[0]))));
            } else {
                this.toggleBtn.m_93666_((Component)Component.m_237113_((String)("\u00a7c" + Locals.localize("configscreen.boolean.disabled", new String[0]))));
            }
            ConfigScreen.colorizeButton(this.toggleBtn);
        }

        @Override
        public void render(PoseStack matrix) {
            super.render(matrix);
            int center = this.x + this.getWidth() / 2;
            this.toggleBtn.setX(center + 9);
            this.toggleBtn.setY(this.y + 3);
            this.toggleBtn.m_6305_(matrix, MouseInput.getMouseX(), MouseInput.getMouseY(), Minecraft.m_91087_().m_91296_());
        }

        @Override
        protected void onSave() {
            this.configEntry.setValue("" + this.state);
        }
    }

    protected static abstract class ConfigScrollAreaEntry
    extends ScrollAreaEntry {
        protected ConfigEntry configEntry;
        protected Font font;
        protected String displayName;

        public ConfigScrollAreaEntry(ScrollArea parent, ConfigEntry configEntry) {
            super(parent);
            this.font = Minecraft.m_91087_().f_91062_;
            this.configEntry = configEntry;
        }

        @Override
        public void renderEntry(PoseStack matrix) {
            int center = this.x + this.getWidth() / 2;
            ConfigScrollAreaEntry.m_93172_((PoseStack)matrix, (int)this.x, (int)this.y, (int)(this.x + this.getWidth()), (int)(this.y + this.getHeight()), (int)ENTRY_BACKGROUND_COLOR.getRGB());
            if (this.displayName != null) {
                int nameWidth = this.font.m_92895_(this.displayName);
                ConfigScrollAreaEntry.m_93236_((PoseStack)matrix, (Font)this.font, (String)this.displayName, (int)(center - nameWidth - 10), (int)(this.y + 10), (int)Color.WHITE.getRGB());
            } else {
                int nameWidth = this.font.m_92895_(this.configEntry.getName());
                ConfigScrollAreaEntry.m_93236_((PoseStack)matrix, (Font)this.font, (String)this.configEntry.getName(), (int)(center - nameWidth - 10), (int)(this.y + 10), (int)Color.WHITE.getRGB());
            }
        }

        @Override
        public int getHeight() {
            return 26;
        }

        protected abstract void onSave();

        public static boolean isHeaderFooterHovered() {
            Screen s = Minecraft.m_91087_().f_91080_;
            if (s != null) {
                int mouseX = MouseInput.getMouseX();
                int mouseY = MouseInput.getMouseY();
                int minXHeaderFooter = 0;
                int maxXHeaderFooter = s.f_96543_;
                int minYHeader = 0;
                int maxYHeader = 50;
                int minYFooter = s.f_96544_ - 50;
                int maxYFooter = s.f_96544_;
                if (mouseX >= minXHeaderFooter && mouseX <= maxXHeaderFooter && mouseY >= minYHeader && mouseY <= maxYHeader) {
                    return true;
                }
                if (mouseX >= minXHeaderFooter && mouseX <= maxXHeaderFooter && mouseY >= minYFooter && mouseY <= maxYFooter) {
                    return true;
                }
            }
            return false;
        }
    }
}

