/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.brewing;

import java.util.List;
import java.util.Objects;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import mezz.jei.library.plugins.vanilla.brewing.BrewingRecipeUtil;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;

public class JeiBrewingRecipe
implements IJeiBrewingRecipe {
    private final List<ItemStack> ingredients;
    private final List<ItemStack> potionInputs;
    private final ItemStack potionOutput;
    private final BrewingRecipeUtil brewingRecipeUtil;
    private final int hashCode;

    public JeiBrewingRecipe(List<ItemStack> ingredients, List<ItemStack> potionInputs, ItemStack potionOutput, BrewingRecipeUtil brewingRecipeUtil) {
        this.ingredients = List.copyOf(ingredients);
        this.potionInputs = List.copyOf(potionInputs);
        this.potionOutput = potionOutput;
        this.brewingRecipeUtil = brewingRecipeUtil;
        brewingRecipeUtil.addRecipe(potionInputs, potionOutput);
        this.hashCode = Objects.hash(ingredients.stream().map(ItemStack::m_41720_).toList(), potionInputs.stream().map(ItemStack::m_41720_).toList(), potionOutput.m_41720_());
    }

    @Override
    public List<ItemStack> getPotionInputs() {
        return this.potionInputs;
    }

    @Override
    public List<ItemStack> getIngredients() {
        return this.ingredients;
    }

    @Override
    public ItemStack getPotionOutput() {
        return this.potionOutput;
    }

    public boolean equals(Object obj) {
        int i;
        if (!(obj instanceof JeiBrewingRecipe)) {
            return false;
        }
        JeiBrewingRecipe other = (JeiBrewingRecipe)obj;
        for (i = 0; i < this.potionInputs.size(); ++i) {
            ItemStack otherPotionInput;
            ItemStack potionInput = this.potionInputs.get(i);
            if (JeiBrewingRecipe.arePotionsEqual(potionInput, otherPotionInput = other.potionInputs.get(i))) continue;
            return false;
        }
        if (!JeiBrewingRecipe.arePotionsEqual(other.potionOutput, this.potionOutput)) {
            return false;
        }
        if (this.ingredients.size() != other.ingredients.size()) {
            return false;
        }
        for (i = 0; i < this.ingredients.size(); ++i) {
            if (ItemStack.m_41728_((ItemStack)this.ingredients.get(i), (ItemStack)other.ingredients.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean arePotionsEqual(ItemStack potion1, ItemStack potion2) {
        if (potion1.m_41720_() != potion2.m_41720_()) {
            return false;
        }
        Potion type1 = PotionUtils.m_43579_((ItemStack)potion1);
        Potion type2 = PotionUtils.m_43579_((ItemStack)potion2);
        IPlatformRegistry<Potion> potionRegistry = Services.PLATFORM.getRegistry(Registry.f_122905_);
        ResourceLocation key1 = potionRegistry.getRegistryName(type1).orElse(null);
        ResourceLocation key2 = potionRegistry.getRegistryName(type2).orElse(null);
        return Objects.equals(key1, key2);
    }

    @Override
    public int getBrewingSteps() {
        return this.brewingRecipeUtil.getBrewingSteps(this.potionOutput);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        Potion inputType = PotionUtils.m_43579_((ItemStack)this.potionInputs.get(0));
        Potion outputType = PotionUtils.m_43579_((ItemStack)this.potionOutput);
        return this.ingredients + " + [" + this.potionInputs.get(0).m_41720_() + " " + inputType.m_43492_("") + "] = [" + this.potionOutput + " " + outputType.m_43492_("") + "]";
    }
}

